<?php

namespace UseePay\klarna\service;

use Magento\Framework\App\ObjectManager;
use Magento\Framework\DB\Transaction;
/**
 * Intended to preserve session cookie after submitting POST form from UseePay to Magento controller.
 */
class InvoiceService
{
    
    const TRANSACTION_TYPE_ORDER = 'order';

    /**
     * @param $order
     * @param $result
     * @param $createInvoice
     * @return false|mixed
     */
    public function createOrderInvoice($order, $result, $createInvoice = true)
    {
        if (!$createInvoice || !$order->canInvoice()) {
            LogService::saveLog('$createInvoice false' . $createInvoice);
            return false;
        }
        LogService::saveLog('$createInvoice true' . $createInvoice);
        $invoice = $order->prepareInvoice();
        if ($invoice->getTotalQty()) {
            $invoice->register();
            $invoice->setState(\Magento\Sales\Model\Order\Invoice::STATE_PAID);
            $invoice->save();
            $order->addRelatedObject($invoice);
        }
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $transactionSave = $objectManager->create('Magento\Framework\DB\Transaction')
            ->addObject($invoice)
            ->addObject($invoice->getOrder());
        $transactionSave->save();
        $order->addStatusHistoryComment(__('Created invoice #%1,reference :'.$result['reference'], $invoice->getId()))->setIsCustomerNotified(true)->save();
        $this->createTransaction($order, $result);

        return $invoice;
    }

    /**
     * @param $order
     * @param $result
     * @return void
     */
    public function createTransaction($order, $result)
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $payment = $objectManager->create('Magento\Sales\Model\Order\Payment');
        $payment->setTransactionId($result['reference']);
        $payment->setOrder($order);
        $payment->setIsTransactionClosed(1);
        $transaction = $payment->addTransaction(self::TRANSACTION_TYPE_ORDER);
        $transaction->beforeSave();
        $transaction->save();
    }
}