/*####################################################################
 # Copyright ©2020 UseePay Ltd. All Rights Reserved.                 #
 # This file may not be redistributed in whole or significant part.  #
 # This file is part of the UseePay package and should not be used   #
 # and distributed for any other purpose that is not approved by     #
 # UseePay Ltd.                                                      #
 # https://www.useepay.com                                           #
 ####################################################################*/

(function (p) {
    p.createAndSubmitFormFor3ds = function (mountedSelector, actionUrl, params, method) {
        $form = $('<form></form>');
        $form.attr('action', actionUrl);
        $form.attr('method', method);
        if (typeof params === 'object') {
            for (var key in params) {
                $form.append('<input type="hidden" name="' + key + '" ' + 'value="' + params[key] + '">');
            }
        }
        $(mountedSelector).append($form);
        $form.submit();
    };
    p.showPageLoading = function (loading_image, loading_text) {
        if ($('.useepay-page-loading').length === 0) {
            $('body').append('<div class="useepay-page-loading"><img src="' + loading_image + '">' + '<h1>' + loading_text + '</h1></div>');
        }
    };
    p._poll = function () {
        $.ajax(
            {
                type: 'GET',
                url: p.pollUrl,
                success: function (status) {
                    if ((status !== -1 && status !== p.pollLastOrderStatus) || p.time > 20) {
                        window.location.href = p.pollRedirectUrl;
                        return;
                    }
                    p.time++;
                    setTimeout(p._poll, 1000);
                },
                error: function (error) {
                    if (p.time > 20) {
                        window.location.href = p.pollRedirectUrl;
                        return;
                    }
                    p.time++;
                    setTimeout(p._poll, 1000);
                },
            }
        );
    }
    p.pollOrderStatusAndRedirect = function (url, redirectUrl, lastOrderStatus) {
        p.time = 1;
        p.pollUrl = url;
        p.pollRedirectUrl = redirectUrl;
        p.pollLastOrderStatus = lastOrderStatus;
        p._poll(url, redirectUrl);
    };
    p.query3dsNextStepAndRedirect = function (threedsNextStepQueryUrl, returnUrl, queryOrderStatusUrl, queryOrderRedirectUrl, lastOrderStatus) {
        $.ajax(
            {
                type: 'GET',
                url: threedsNextStepQueryUrl,
                success: function (resp) {
                    if (resp === -1) {
                        p.pollOrderStatusAndRedirect(queryOrderStatusUrl, queryOrderRedirectUrl, lastOrderStatus);
                    } else {
                        let json;
                        try{
                            json = JSON.parse(resp);
                        } catch (e) {
                            p.pollOrderStatusAndRedirect(queryOrderStatusUrl, queryOrderRedirectUrl, lastOrderStatus);
                            return;
                        }
                        if (json.resultCode === 'challenge') {
                            window.location.href = json.redirectUrl;
                        } else {
                            let url = new URL(returnUrl);
                            url.searchParams.append('resp', resp);
                            window.location.href = url.toString();
                        }
                    }
                },
                error: function (error) {
                    p.pollOrderStatusAndRedirect(queryOrderStatusUrl, queryOrderRedirectUrl, lastOrderStatus);
                }
            }
        );
    }


})(UseePay = {});
