<?php
/*####################################################################
 # Copyright ©2020 UseePay Ltd. All Rights Reserved.                 #
 # This file may not be redistributed in whole or significant part.  #
 # This file is part of the UseePay package and should not be used   #
 # and distributed for any other purpose that is not approved by     #
 # UseePay Ltd.                                                      #
 # https://www.useepay.com                                           #
 ####################################################################*/

abstract class WC_UseePay_Cashier_For_GooglePay_Payment_Gateway extends WC_Payment_Gateway
{
    const ID                                = 'useepaycashierforgooglepay';
    const SETTINGS_KEY_ENABLED              = 'enabled';
    const SETTINGS_KEY_TITLE                = 'title';
    const SETTINGS_KEY_FRONT_CHECKOUT_TITLE = 'checkoutTitle';
    const SETTINGS_KEY_MERCHANT_NO          = 'useepay_merchant_no';
    const SETTINGS_KEY_SECURITY_KEY         = 'useepay_key';
    const SETTINGS_KEY_APP_ID               = 'useepay_app_id';
    const SETTINGS_KEY_SANDBOX_MODE         = 'testmode';
    const SETTINGS_KEY_DEBUG_LOG            = 'debug';
    const SETTINGS_KEY_DESCRIPTION          = 'description';
    const SETTINGS_KEY_CHECKOUT_LOGO         = 'checkoutLogo';
    const USEEPAY_PAYMENT_METHOD             = 'googlepay';
    const PLUGIN_USEEPAY_PAYMENT_METHOD_TITLE = 'Google Pay';
    const PLUGIN_TRANSLATE_FILE = 'useepay-for-woocommerce';

    public function __construct()
    {
        $this->id = self::ID;
        $this->init_form_fields();
        $this->init_settings();
        $this->title       = $this->get_option(self::SETTINGS_KEY_TITLE);
        $this->enabled     = $this->get_option(self::SETTINGS_KEY_ENABLED);
        $this->description  = $this->get_option(self::SETTINGS_KEY_DESCRIPTION);
        $this->checkoutTitle   = $this->get_option(self::SETTINGS_KEY_FRONT_CHECKOUT_TITLE);
    }

    public function init_form_fields()
    {
        $this->method_title = $this->getModuleTitle();
        $this->form_fields  = array(
            self::SETTINGS_KEY_ENABLED              => array(
                'title'   => __('Enable/Disable', self::PLUGIN_TRANSLATE_FILE),
                'type'    => 'checkbox',
                'label'   => __('Enable UseePay - '. self::PLUGIN_USEEPAY_PAYMENT_METHOD_TITLE , self::PLUGIN_TRANSLATE_FILE),
                'default' => 'no'
            ),
            self::SETTINGS_KEY_TITLE                => array(
                'title'       => __('Title', self::PLUGIN_TRANSLATE_FILE),
                'type'        => 'text',
                'description' => __('This controls the title which the user sees during checkout.', self::PLUGIN_TRANSLATE_FILE),
                'default'     => __(self::PLUGIN_USEEPAY_PAYMENT_METHOD_TITLE, self::PLUGIN_TRANSLATE_FILE),
                'desc_tip'    => true,
            ),
            self::SETTINGS_KEY_DESCRIPTION => array(
                'title'       => __('Description', self::PLUGIN_TRANSLATE_FILE),
                'type'        => 'textarea',
                'description' => __('This controls the description which the user sees during checkout.', self::PLUGIN_TRANSLATE_FILE),
                'default'     => __('Pay via' . self::PLUGIN_USEEPAY_PAYMENT_METHOD_TITLE , self::PLUGIN_TRANSLATE_FILE),
                'desc_tip'    => true,
            ),
            self::SETTINGS_KEY_MERCHANT_NO          => array(
                'title'       => __('Merchant No', self::PLUGIN_TRANSLATE_FILE),
                'type'        => 'text',
                'description' => __('Please enter the Merchant No<br />If you dont have one, <a href=\"https://useepay.com/global-payment-acquiring-apply\" target=\"_blank\">click here</a> to get.', 'useepay-for-woocommerce'),
                'css'         => 'width:400px'
            ),
            self::SETTINGS_KEY_SECURITY_KEY         => array(
                'title'       => __('Security Key', self::PLUGIN_TRANSLATE_FILE),
                'type'        => 'text',
                'description' => __('Please enter the security key<br />If you dont have one, <a href=\"https://useepay.com/global-payment-acquiring-apply\" target=\"_blank\">click here</a> to get.', 'useepay-for-woocommerce'),
                'css'         => 'width:400px'
            ),
            self::SETTINGS_KEY_APP_ID               => array(
                'title'       => __('UseePay App Id', self::PLUGIN_TRANSLATE_FILE),
                'type'        => 'text',
                'description' => __('Please enter your UseePay App Id ; this is needed in order to take payment.', self::PLUGIN_TRANSLATE_FILE),
                'css'         => 'width:200px',
                'desc_tip'    => true,
            ),
            self::SETTINGS_KEY_SANDBOX_MODE         => array(
                'title'       => __('Sandbox Mode', self::PLUGIN_TRANSLATE_FILE),
                'type'        => 'checkbox',
                'label'       => __('Enable Sandbox Mode',self::PLUGIN_TRANSLATE_FILE),
                'default'     => 'no',
                'description' => __('Enable Sandbox Mode', self::PLUGIN_TRANSLATE_FILE)
            ),
            self::SETTINGS_KEY_DEBUG_LOG => array(
                'title'       => __('Debug Log',self::PLUGIN_TRANSLATE_FILE),
                'type'        => 'checkbox',
                'label'       => __('Enable logging',self::PLUGIN_TRANSLATE_FILE),
                'default'     => 'no',
                'description' => sprintf(__('Log UseePay events, such as trade status, inside %1$s',self::PLUGIN_TRANSLATE_FILE), '<code>' . wc_get_log_file_path('useepay') . '</code>')
            ),
            self::SETTINGS_KEY_FRONT_CHECKOUT_TITLE => array(
                'title'       => __('Checkout Title', self::PLUGIN_TRANSLATE_FILE),
                'type'        => 'text',
                'description' => __('This controls the checkout title which the user sees during checkout.', self::PLUGIN_TRANSLATE_FILE),
                'default'     => __('Buy with', self::PLUGIN_TRANSLATE_FILE),
                'desc_tip'    => true,
            ),
            self::SETTINGS_KEY_CHECKOUT_LOGO => array(
                'title'       => __('Checkout Logo', self::PLUGIN_TRANSLATE_FILE),
                'type'        => 'text',
                'description' => __('This controls the logo which the user sees during checkout.', self::PLUGIN_TRANSLATE_FILE),
                'default'     => __('https://static.useepay.com/public-static/checkout/payment-method/GooglePay.svg', self::PLUGIN_TRANSLATE_FILE),
                'desc_tip'    => true,
            ),
        );
    }

    protected function getModuleTitle(): string
    {
        return __('UseePay', self::PLUGIN_TRANSLATE_FILE);
    }

    public function is_available()
    {
        if ('yes' === $this->enabled) {
            return true;
        }

        return parent::is_available(); // TODO: Change the autogenerated stub
    }


    protected function get_merchant_no()
    {
        return $this->get_option(self::SETTINGS_KEY_MERCHANT_NO);
    }

    protected function get_app_id()
    {
        return $this->get_option(self::SETTINGS_KEY_APP_ID);
    }

    protected function get_secret_key()
    {
        return $this->get_option(self::SETTINGS_KEY_SECURITY_KEY);
    }

    protected function get_checkout_title()
    {
        return $this->get_option(self::SETTINGS_KEY_FRONT_CHECKOUT_TITLE);
    }

    protected function get_payment_method()
    {
        return $this->get_option(self::USEEPAY_PAYMENT_METHOD);
    }
    protected function get_checkout_logo()
    {
        return $this->get_option(self::SETTINGS_KEY_CHECKOUT_LOGO);
    }
    protected function get_plugin_useepay_payment_method_title()
    {
        return self::PLUGIN_USEEPAY_PAYMENT_METHOD_TITLE;
    }

    protected function get_plugin_translate_file()
    {
        return self::PLUGIN_TRANSLATE_FILE;
    }
}