<?php
/*####################################################################
 # Copyright ©2020 UseePay Ltd. All Rights Reserved.                 #
 # This file may not be redistributed in whole or significant part.  #
 # This file is part of the UseePay package and should not be used   #
 # and distributed for any other purpose that is not approved by     #
 # UseePay Ltd.                                                      #
 # https://www.useepay.com                                           #
 ####################################################################*/

abstract class WC_UseePay_Inner_Payment_Gateway extends WC_Payment_Gateway
{

    public function payment_scripts() {
        if (
            ! is_product()
            && ! WC_Useepay_Inner_Helper::has_cart_or_checkout_on_current_page()
            && ! $this->is_valid_pay_for_order_endpoint()
            && ! is_add_payment_method_page()
            && ! isset( $_GET['change_payment_method'] ) // wpcs: csrf ok.
            && ! ( ! empty( get_query_var( 'view-subscription' ) ) && is_callable( 'WCS_Early_Renewal_Manager::is_early_renewal_via_modal_enabled' ) && WCS_Early_Renewal_Manager::is_early_renewal_via_modal_enabled() )
            || ( is_order_received_page() )
        ) {
            return;
        }

        // If Useepay is not enabled bail.
        if ( 'no' === $this->enabled ) {
            return;
        }

        $suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

//        wp_register_script( 'woocommerce_useepay', plugins_url( 'assets/js/useepay.min' . '.js', WC_USEEPAY_INNER_MAIN_FILE ), [], WC_USEEPAY_INNER_VERSION, true );
        wp_register_script( 'woocommerce_useepay', 'https://cashier.useepay.com/jssdkV3/1.0.0/useepay.min.js', [], WC_USEEPAY_INNER_VERSION, true );
        wp_localize_script(
            'woocommerce_useepay',
            'wc_useepay_params',
            apply_filters( 'wc_useepay_params', $this->get_js_params() )
        );


        wp_enqueue_script( 'woocommerce_useepay' );
    }

    public function get_js_params(){
        $order_id = absint( get_query_var( 'order-pay' ) );
        $options = get_option('woocommerce_' . $this->id . '_settings', []);
        $sandbox_mode       = isset($options["testMode"]) && 'yes' === $options["testMode"];
        $endpoint           = $sandbox_mode ? 'UAT' : 'PRODUCTION';
        $parmas = [
            'orderId' => $order_id,
            'mode'    => $endpoint,
        ];
        return array_merge($parmas, $options);
    }

    /**
     * Checks if the current page is the pay for order page and the current user is allowed to pay for the order.
     *
     * @return bool
     */
    public function is_valid_pay_for_order_endpoint(): bool {

        // If not on the pay for order page, return false.
        if ( ! is_wc_endpoint_url( 'order-pay' ) || ! isset( $_GET['key'] ) ) {
            return false;
        }

        $order_id = absint( get_query_var( 'order-pay' ) );
        $order    = wc_get_order( $order_id );

        // If the order is not found or the param `key` is not set or the order key does not match the order key in the URL param, return false.
        if ( ! $order || ! isset( $_GET['key'] ) || wc_clean( wp_unslash( $_GET['key'] ) ) !== $order->get_order_key() ) {
            return false;
        }

        // If the order doesn't need payment, we don't need to prepare the payment page.
        if ( ! $order->needs_payment() ) {
            return false;
        }

        return current_user_can( 'pay_for_order', $order->get_id() );
    }
}