<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$is_gte_wc6_6 = defined( WC_VERSION ) && version_compare( WC_VERSION, '6.6', '>=' );

$useepay_settings = apply_filters(
    'wc_useepay_settings',
    [
        'enabled'                             => [
            'title'       => __( 'Enable/Disable', 'useepay-for-woocommerce' ),
            'label'       => __( 'Enable UseePay', 'useepay-for-woocommerce' ),
            'type'        => 'checkbox',
            'default'     => 'no',
        ],
        'title'                               => [
            'title'       => __( 'Title', 'useepay-for-woocommerce' ),
            'type'        => $is_gte_wc6_6 ? 'safe_text' : 'text',
            'description' => __( 'This controls the title which the user sees during checkout.', 'useepay-for-woocommerce' ),
            'default'     => __( 'Credit Card (UseePay)', 'useepay-for-woocommerce' ),
            'desc_tip'    => true,
        ],
        'merchantNo'                               => [
            'title'       => __( 'Merchant No', 'useepay-for-woocommerce' ),
            'type'        => $is_gte_wc6_6 ? 'safe_text' : 'text',
            'description' => __('Please enter the Merchant No<br />If you dont have one, <a href=\"https://useepay.com/global-payment-acquiring-apply\" target=\"_blank\">click here</a> to get.', 'useepay-for-woocommerce'),
            'css'         => 'width:400px'
        ],
        'useepay_key'                               => [
            'title'       => __( 'Security Key', 'useepay-for-woocommerce' ),
            'type'        => $is_gte_wc6_6 ? 'safe_text' : 'text',
            'description' => __('Please enter the security key<br />If you dont have one, <a href=\"https://useepay.com/global-payment-acquiring-apply\" target=\"_blank\">click here</a> to get.', 'useepay-for-woocommerce'),
            'css'         => 'width:400px'
        ],
        'useepay_app_id'                               => [
            'title'       => __( 'UseePay App Id', 'useepay-for-woocommerce' ),
            'type'        => $is_gte_wc6_6 ? 'safe_text' : 'text',
            'description' => __('Please enter your UseePay App Id ; this is needed in order to take payment.', 'useepay-for-woocommerce'),
            'css'         => 'width:200px',
            'desc_tip'    => true,
        ],
        'testMode'                               => [
            'title'       => __('Sandbox Mode', 'useepay-for-woocommerce'),
            'type'        => 'checkbox',
            'label'       => __('Enable Sandbox Mode', 'useepay-for-woocommerce'),
            'default'     => 'no',
            'description' => __('Enable Sandbox Mode', 'useepay-for-woocommerce')
        ],
        'debug'                               => [
            'title'       => __('Debug Log', 'useepay-for-woocommerce'),
            'type'        => 'checkbox',
            'label'       => __('Enable logging', 'useepay-for-woocommerce'),
            'default'     => 'no',
            'description' => sprintf(__('Log UseePay events, such as trade status, inside %1$s', 'useepay-for-woocommerce'), '<code>' . wc_get_log_file_path('useepay_inner') . '</code>')
        ],
    ]
);

return apply_filters(
    'wc_useepay_settings',
    $useepay_settings
);