<?php

require_once 'Mage/Checkout/controllers/OnepageController.php';

class UseePay_Checkout_OnepageController extends Mage_Checkout_OnepageController
{
    /**
     * Create order action (overwriten)
     */
    public function saveOrderAction()
    {
        if (!$this->_validateFormKey()) {
            $this->_redirect('*/*');
            return;
        }

        if ($this->_expireAjax()) {
            return;
        }

        $result = array();
        try {
            $requiredAgreements = Mage::helper('checkout')->getRequiredAgreementIds();
            if ($requiredAgreements) {
                $postedAgreements = array_keys($this->getRequest()->getPost('agreement', array()));
                $diff             = array_diff($requiredAgreements, $postedAgreements);
                if ($diff) {
                    $result['success']        = false;
                    $result['error']          = true;
                    $result['error_messages'] = $this->__('Please agree to all the terms and conditions before placing the order.');
                    $this->getResponse()->setBody(Mage::helper('core')->jsonEncode($result));
                    return;
                }
            }

            $data = $this->getRequest()->getPost('payment', array());
            if ($data) {
                $data['checks'] = Mage_Payment_Model_Method_Abstract::CHECK_USE_CHECKOUT
                    | Mage_Payment_Model_Method_Abstract::CHECK_USE_FOR_COUNTRY
                    | Mage_Payment_Model_Method_Abstract::CHECK_USE_FOR_CURRENCY
                    | Mage_Payment_Model_Method_Abstract::CHECK_ORDER_TOTAL_MIN_MAX
                    | Mage_Payment_Model_Method_Abstract::CHECK_ZERO_TOTAL;
                $this->getOnepage()->getQuote()->getPayment()->importData($data);
            }

            $this->getOnepage()->saveOrder();

            $redirectUrl   = $this->getOnepage()->getCheckout()->getRedirectUrl();
            $isTranSuccess = Mage::getSingleton('core/session')->getIsTranSuccess();
            Mage::log('保存session数据：' . var_export($isTranSuccess, true), null, "UseePays.log");
            $result['success'] = true;
            $result['error']   = false;
            if ($isTranSuccess['useepay'] == 1) {
                if ($isTranSuccess['status'] == 2) {
                    $result['payMethodResp'] = $isTranSuccess['payMethodResp'];
                    $isTranSuccess           = array(
                        'useepay' => 1,
                        'status'    => 1
                    );
                    Mage::getSingleton('core/session')->setIsTranSuccess($isTranSuccess);
                    $result['success'] = false;
                    $result['error']   = true;
                    unset($redirectUrl);
                } elseif ($isTranSuccess['status'] == 0) {
                    $isTranSuccess = array(
                        'useepay' => 1,
                        'status'    => 1
                    );
                    Mage::getSingleton('core/session')->setIsTranSuccess($isTranSuccess);
                    if (!isset($redirectUrl)) {
                        $redirectUrl = Mage::getUrl('checkout/onepage/failure');
                    }
                }
            }
        } catch (Mage_Payment_Model_Info_Exception $e) {
            $message = $e->getMessage();
            if (!empty($message)) {
                $result['error_messages'] = $message;
            }
            $result['goto_section']   = 'payment';
            $result['update_section'] = array(
                'name' => 'payment-method',
                'html' => $this->_getPaymentMethodsHtml()
            );
        } catch (Mage_Core_Exception $e) {
            Mage::logException($e);
            Mage::helper('checkout')->sendPaymentFailedEmail($this->getOnepage()->getQuote(), $e->getMessage());
            $result['success']        = false;
            $result['error']          = true;
            $result['error_messages'] = $e->getMessage();

            $gotoSection = $this->getOnepage()->getCheckout()->getGotoSection();
            if ($gotoSection) {
                $result['goto_section'] = $gotoSection;
                $this->getOnepage()->getCheckout()->setGotoSection(null);
            }
            $updateSection = $this->getOnepage()->getCheckout()->getUpdateSection();
            if ($updateSection) {
                if (isset($this->_sectionUpdateFunctions[$updateSection])) {
                    $updateSectionFunction    = $this->_sectionUpdateFunctions[$updateSection];
                    $result['update_section'] = array(
                        'name' => $updateSection,
                        'html' => $this->$updateSectionFunction()
                    );
                }
                $this->getOnepage()->getCheckout()->setUpdateSection(null);
            }
        } catch (Exception $e) {
            Mage::logException($e);
            Mage::helper('checkout')->sendPaymentFailedEmail($this->getOnepage()->getQuote(), $e->getMessage());
            $result['success']        = false;
            $result['error']          = true;
            $result['error_messages'] = $this->__('There was an error processing your order. Please contact us or try again later.');
        }
        $this->getOnepage()->getQuote()->save();
        /**
         * when there is redirect to third party, we don't want to save order yet.
         * we will save the order in return action.
         */
        if (isset($redirectUrl)) {
            $result['redirect'] = $redirectUrl;
        }

        $this->getResponse()->setBody(Mage::helper('core')->jsonEncode($result));
    }

    /**
     * priceת����С��λ����
     * @param $currency
     * @param $price
     * @return int
     */
    function convert_price($currency, $price, $times = 2)
    {
        $currency          = strtoupper($currency);
        $currency_map_json = '{"EUR":2,"AMD":2,"BOV":2,"XAF":0,"COP":2,"COU":2,"CUP":2,"ANG":2,"DOP":2,"HKD":2,"IRR":2,"NPR":2,"PYG":0,"QAR":2,"RON":2,"SBD":2,"SOS":2,"LKR":2,"TWD":2,"VUV":0,"XTS":0,"XAU":0,"AOA":2,"ARS":2,"BRL":2,"BGN":2,"KHR":2,"KMF":0,"CDF":2,"GNF":0,"HNL":2,"ISK":0,"ILS":2,"JPY":0,"KWD":3,"LBP":2,"LYD":3,"MWK":2,"MXV":2,"PKR":2,"RWF":0,"STD":2,"SLL":2,"CHW":2,"UGX":0,"USN":2,"UZS":2,"XBB":0,"BBD":2,"XOF":0,"BMD":2,"CAD":2,"NZD":2,"CZK":2,"FJD":2,"GBP":2,"ZAR":2,"LRD":2,"PHP":2,"WST":2,"SCR":2,"SDG":2,"TMT":2,"UYI":0,"XBA":0,"BAM":2,"BWP":2,"CLP":0,"CRC":2,"GYD":2,"JOD":3,"MKD":2,"MUR":2,"MDL":2,"MNT":2,"NGN":2,"SRD":2,"SEK":2,"TZS":2,"TOP":2,"UAH":2,"UYU":2,"ZWL":2,"USD":2,"BSD":2,"BYN":2,"BZD":2,"CLF":4,"GHS":2,"GTQ":2,"IQD":3,"KRW":0,"MOP":2,"MXN":2,"MAD":2,"NIO":2,"XSU":0,"SZL":2,"THB":2,"VND":0,"ZMW":2,"XPD":0,"AFN":2,"AUD":2,"BOB":2,"CNY":2,"HRK":2,"DJF":0,"EGP":2,"ETB":2,"GEL":2,"HTG":2,"XDR":0,"JMD":2,"KZT":2,"KPW":2,"MGA":2,"MVR":2,"XUA":0,"MMK":2,"NAD":2,"OMR":3,"PGK":2,"RUB":2,"TTD":2,"XXX":0,"ALL":2,"DZD":2,"XCD":2,"AZN":2,"BDT":2,"INR":2,"BTN":2,"NOK":2,"BND":2,"BIF":0,"CUC":2,"SVC":2,"FKP":2,"XPF":0,"GMD":2,"HUF":2,"KES":2,"KGS":2,"LAK":2,"MYR":2,"MRO":2,"PAB":2,"PEN":2,"RSD":2,"SGD":2,"CHE":2,"TND":3,"TRY":2,"VEF":2,"YER":2,"XBD":0,"XPT":0,"XAG":0,"AWG":2,"BHD":3,"CVE":2,"KYD":2,"DKK":2,"ERN":2,"GIP":2,"IDR":2,"LSL":2,"CHF":2,"MZN":2,"PLN":2,"SHP":2,"SAR":2,"SSP":2,"SYP":2,"TJS":2,"AED":2,"XBC":0}';
        $currency_map      = json_decode($currency_map_json, true);
        if (array_key_exists($currency, $currency_map)) {
            $times = $currency_map[$currency];
        }
        $price = round($price, $times);
        while ($times--) {
            $price *= 10;
        }
        return intval($price);
    }

    public function returnAction()
    {
        if ($this->getRequest()->isPost()) {
            $postData = $this->getRequest()->getPost();

            $config        = Mage::getStoreConfig('payment/useepayapi');
            $security_code = $config['useepay_user_key'];

            ksort($postData);
            $signStr = '';
            foreach ($postData as $key => $value) {
                if ('' != $value && 'sign' != $key) {
                    $signStr .= '&' . $key . '=' . trim($value);
                }
            }
            $signStr    = substr($signStr, 1);
            $signParams = $signStr;
            $signStr    .= "&pkey=" . $security_code;
            $mysign     = strtolower(md5($signStr));

            $statusFromUseePay = $postData["status"];
            Mage::log('保存同步订单：' . var_export($postData, true), null, "UseePay.log");
            if ($mysign == $postData["sign"] && '' != $postData["sign"]) {
                $order = Mage::getModel('sales/order');
                $order->loadByIncrementId($postData['transId']);

                $mstate = $order->getState();

                if ('success' == $statusFromUseePay) {
                    if (Mage_Sales_Model_Order::STATE_PROCESSING != $mstate) {
                        $order->setData('state', Mage_Sales_Model_Order::STATE_PROCESSING);
                        $order->setData('status', Mage_Sales_Model_Order::STATE_PROCESSING);
                        $order->addStatusToHistory(Mage_Sales_Model_Order::STATE_PROCESSING, Mage::helper('paygate')->__('Transaction is paid successfully.'));
                        try {
                            $order->save();
                            Mage::log('同步保存成功订单成功', null, "UseePay.log");
                        } catch (Exception $e) {
                            Mage::log('保存成功订单异常：' . $e, null, "UseePay.log");
                        }
                    }
                } elseif ('failed' == $statusFromUseePay || 'expired' == $statusFromUseePay || 'canceled' == $statusFromUseePay) {
                    if (Mage_Sales_Model_Order::STATE_PROCESSING != $mstate && Mage_Sales_Model_Order::STATE_CLOSED != $mstate) {
                        $order->setData('state', Mage_Sales_Model_Order::STATE_CLOSED);
                        $order->setData('status', Mage_Sales_Model_Order::STATE_CLOSED);
                        $order->addStatusToHistory(Mage_Sales_Model_Order::STATE_CLOSED, Mage::helper('paygate')->__('Transaction process payment failed. result is:(' . $postData['respCode'] . ':' . $postData['respMsg'] . ').'));
                        try {
                            $order->save();
                            Mage::log('同步保存失败订单成功', null, "UseePay.log");
                        } catch (Exception $e) {
                            Mage::log("保存失败订单异常：" . $e, null, "UseePay.log");
                        }
                    }
                } else {
                    if (Mage_Sales_Model_Order::STATE_PROCESSING != $mstate && Mage_Sales_Model_Order::STATE_CLOSED != $mstate && Mage_Sales_Model_Order::STATE_PENDING_PAYMENT != $mstate) {
                        $order->setData('state', Mage_Sales_Model_Order::STATE_PENDING_PAYMENT);
                        $order->setData('status', Mage_Sales_Model_Order::STATE_PENDING_PAYMENT);
                        $order->addStatusToHistory(Mage_Sales_Model_Order::STATE_PENDING_PAYMENT, Mage::helper('paygate')->__('Transaction process payment pending, waiting payment result'));
                        try {
                            $order->save();
                            Mage::log('同步保存pending订单成功', null, "UseePay.log");
                        } catch (Exception $e) {
                            Mage::log('保存pending订单异常:' . $e, null, "UseePay.log");
                        }
                    }
                }
                if ($postData["status"] == 'success') {
                    $appendHtml = "window.location.href=location.protocol + \"//\" + location.host+\"/checkout/onepage/success\";";
                } elseif ($postData["status"] == 'pending') {
                    $appendHtml = "window.location.href=location.protocol + \"//\" + location.host+\"/checkout/onepage/pending\";";
                } else {
                    $appendHtml = "window.location.href=location.protocol + \"//\" + location.host+\"/checkout/onepage/failure\";";
                }
                $html = "<div></div><script type='text/javascript'>if (window.parent.document.getElementById(\"isGather\")) { window.parent.postMessage(" . json_encode($postData) . ", location.protocol + \"//\" + location.host);} else {$appendHtml}</script>";
                echo $html;
            } else {
                Mage::log("CheckSignFail:" . $signParams, null, "UseePay.log");
                $this->getResponse()->setRedirect(Mage::getUrl('checkout/onepage/failure'), 200);
            }
        } else {
            $this->getResponse()->setRedirect(Mage::getUrl('checkout/onepage/failure'), 200);
        }
    }

    public function successAction()
    {
        $session = $this->getOnepage()->getCheckout();
        if (!$session->getLastSuccessQuoteId()) {
            $this->_redirect('checkout/cart');
            return;
        }

        $lastQuoteId           = $session->getLastQuoteId();
        $lastOrderId           = $session->getLastOrderId();
        $lastRecurringProfiles = $session->getLastRecurringProfileIds();
        if (!$lastQuoteId || (!$lastOrderId && empty($lastRecurringProfiles))) {
            $this->_redirect('checkout/cart');
            return;
        }

        $session->clear();
        $this->loadLayout();
        $this->_initLayoutMessages('checkout/session');
        Mage::dispatchEvent('checkout_onepage_controller_success_action', array('order_ids' => array($lastOrderId)));
        $this->renderLayout();
    }

    public function failureAction()
    {
        $lastQuoteId = $this->getOnepage()->getCheckout()->getLastQuoteId();
        $lastOrderId = $this->getOnepage()->getCheckout()->getLastOrderId();

        if (!$lastQuoteId || !$lastOrderId) {
            $this->_redirect('checkout/cart');
            return;
        }

        $this->loadLayout();
        $this->renderLayout();
    }

    public function pendingAction()
    {
        $lastQuoteId = $this->getOnepage()->getCheckout()->getLastQuoteId();
        $lastOrderId = $this->getOnepage()->getCheckout()->getLastOrderId();
        if (!$lastQuoteId || !$lastOrderId) {
            $this->_redirect('checkout/cart');
            return;
        }

        $this->loadLayout();
        $this->renderLayout();
    }
}
