<?php


class SignatureHelper
{
    public static function createMd5Signature($arr, $secretKey)
    {
        if (empty($arr) || empty($secretKey)) {
            return false;
        }
        $str = '';
        ksort($arr);
        foreach ($arr as $key => $value) {
            $v = trim($value);
            if (strlen($v) > 0 && $key != 'sign') {
                $str .= '&' . $key . '=' . $v;
            }
        }
        $str = substr($str, 1);
        $str .= "&pkey=" . trim($secretKey);
        return strtolower(md5($str));
    }

    public static function verifyMd5Signature($arr, $secretKey)
    {
        if (empty($arr) || empty($secretKey)) {
            return false;
        }
        return $arr['sign'] == self::createMd5Signature($arr, $secretKey);
    }

}