<?php

define("USEEPAYAPI_VERSION", "1.0");


/**
 * USEEPAYAPI Transaction Class
 *
 */
class UseePay_UseePayApi_Model_ApiService
{

    // Required for all transactions
    public $key;            // Source key
    public $pin;            // Source pin (optional)
    public $amount;        // the entire amount that will be charged to the customers card
    // (including tax, shipping, etc)
    public $invoice;        // invoice number.  must be unique.  limited to 10 digits.  use orderid if you need longer.

    // Required for Commercial Card support
    public $ponum;            // Purchase Order Number
    public $tax;            // Tax
    public $nontaxable;    // Order is non taxable

    // Amount details (optional)
    public $tip;            // Tip
    public $shipping;        // Shipping charge
    public $discount;    // Discount amount (ie gift certificate or coupon code)
    public $subtotal;    // if subtotal is set, then
    // subtotal + tip + shipping - discount + tax must equal amount
    // or the transaction will be declined.  If subtotal is left blank
    // then it will be ignored
    public $currency;        // Currency of $amount

    // Required Fields for Card Not Present transacitons (Ecommerce)
    public $card;            // card number, no dashes, no spaces
    public $exp;            // expiration date 4 digits no /
    public $cardholder;    // name of card holder
    public $street;        // street address
    public $zip;            // zip code

    // Fields for Card Present (POS)
    public $magstripe;    // mag stripe data.  can be either Track 1, Track2  or  Both  (Required if card,exp,cardholder,street and zip aren't filled in)
    public $cardpresent;   // Must be set to true if processing a card present transaction  (Default is false)
    public $termtype;    // The type of terminal being used:  Optons are  POS - cash register, StandAlone - self service terminal,  Unattended - ie gas pump, Unkown  (Default:  Unknown)
    public $magsupport;    // Support for mag stripe reader:   yes, no, contactless, unknown  (default is unknown unless magstripe has been sent)
    public $contactless;    // Magstripe was read with contactless reader:  yes, no  (default is no)
    public $dukpt;            // DUK/PT for PIN Debit
    public $signature;     // Signature Capture data

    // fields required for check transactions
    public $account;        // bank account number
    public $routing;        // bank routing number
    public $ssn;            // social security number
    public $dlnum;            // drivers license number (required if not using ssn)
    public $dlstate;        // drivers license issuing state
    public $checknum;        // Check Number
    public $accounttype;       // Checking or Savings
    public $checkformat;    // Override default check record format
    public $checkimage_front;    // Check front
    public $checkimage_back;        // Check back


    // Fields required for Secure Vault Payments (Direct Pay)
    public $svpbank;        // ID of cardholders bank
    public $svpreturnurl;    // URL that the bank should return the user to when tran is completed
    public $svpcancelurl;    // URL that the bank should return the user if they cancel


    // Option parameters
    public $origauthcode;    // required if running postauth transaction.
    public $command;        // type of command to run; Possible values are:
    // sale, credit, void, preauth, postauth, check and checkcredit.
    // Default is sale.
    public $orderid;        // Unique order identifier.  This field can be used to reference
    // the order for which this transaction corresponds to. This field
    // can contain up to 64 characters and should be used instead of
    // UMinvoice when orderids longer that 10 digits are needed.
    public $custid;   // Alpha-numeric id that uniquely identifies the customer.
    public $description;    // description of charge
    public $cvv2;            // cvv2 code
    public $custemail;        // customers email address
//	public $custreceipt;	// send customer a receipt
//	public $custreceipt_template;	// select receipt template
    public $ignoreduplicate; // prevent the system from detecting and folding duplicates
    public $ip;            // ip address of remote host
    public $testmode;        // test transaction but don't process it
//	public $usesandbox;    // use sandbox server instead of production
    public $timeout;       // transaction timeout.  defaults to 45 seconds
    public $gatewayurl;    // url for the gateway
    public $proxyurl;        // proxy server to use (if required by network)
    public $ignoresslcerterrors;  // Bypasses ssl certificate errors.  It is highly recommended that you do not use this option.  Fix your openssl installation instead!
    public $cabundle;      // manually specify location of root ca bundle (useful of root ca is not in default location)
    public $transport;     // manually select transport to use (curl or stream), by default the library will auto select based on what is available

    // Card Authorization - Verified By Visa and Mastercard SecureCode
    public $cardauth;        // enable card authentication
    public $pares;        //

    // Third Party Card Authorization
    public $xid;
    public $cavv;
    public $eci;

    // Recurring Billing
    public $recurring;        //  Save transaction as a recurring transaction:  yes/no
    public $schedule;        //  How often to run transaction: daily, weekly, biweekly, monthly, bimonthly, quarterly, annually.  Default is monthly.
    public $numleft;        //  The number of times to run. Either a number or * for unlimited.  Default is unlimited.
    public $start;            //  When to start the schedule.  Default is tomorrow.  Must be in YYYYMMDD  format.
    public $end;            //  When to stop running transactions. Default is to run forever.  If both end and numleft are specified, transaction will stop when the ealiest condition is met.
    public $billamount;    //  Optional recurring billing amount.  If not specified, the amount field will be used for future recurring billing payments
    public $billtax;
    public $billsourcekey;

    // Billing Fields
    public $billfname;
    public $billlname;
    public $billcompany;
    public $billstreet;
    public $billstreet2;
    public $billcity;
    public $billstate;
    public $billzip;
    public $billcountry;
    public $billphone;
    public $email;
    public $fax;
    public $website;

    // Shipping Fields
    public $delivery;        // type of delivery method ('ship','pickup','download')
    public $shipfname;
    public $shiplname;
    public $shipcompany;
    public $shipstreet;
    public $shipstreet2;
    public $shipcity;
    public $shipstate;
    public $shipzip;
    public $shipcountry;
    public $shipphone;

    // Custom Fields
    public $custom1;
    public $custom2;
    public $custom3;
    public $custom4;
    public $custom5;
    public $custom6;
    public $custom7;
    public $custom8;
    public $custom9;
    public $custom10;
    public $custom11;
    public $custom12;
    public $custom13;
    public $custom14;
    public $custom15;
    public $custom16;
    public $custom17;
    public $custom18;
    public $custom19;
    public $custom20;


    // Line items  (see addLine)
    public $lineitems;


    public $comments; // Additional transaction details or comments (free form text field supports up to 65,000 chars)

    public $software; // Allows developers to identify their application to the gateway (for troubleshooting purposes)


    // response fields
    public $rawresult;        // raw result from gateway
    public $result;        // full result:  Approved, Declined, Error
    public $resultcode;    // abreviated result code: A D E
    public $authcode;        // authorization code
    public $refnum;        // reference number
    public $batch;        // batch number
    public $avs_result;        // avs result
    public $avs_result_code;        // avs result
    public $avs;                    // obsolete avs result
    public $cvv2_result;        // cvv2 result
    public $cvv2_result_code;        // cvv2 result
    public $vpas_result_code;      // vpas result
    public $isduplicate;      // system identified transaction as a duplicate
    public $convertedamount;  // transaction amount after server has converted it to merchants currency
    public $convertedamountcurrency;  // merchants currency
    public $conversionrate;  // the conversion rate that was used
    public $custnum;  //  gateway assigned customer ref number for recurring billing

    // Cardinal Response Fields
    public $acsurl;    // card auth url
    public $pareq;        // card auth request
    public $cctransid; // cardinal transid


    // Errors Response Feilds
    public $error;        // error message if result is an error
    public $errorcode;    // numerical error code
    public $blank;            // blank response
    public $transporterror;    // transport error

    // Extended Fraud Profiler Fields
    public $session; // session id
    // responses fields
    public $profilerScore;
    public $profilerResponse;
    public $profilerReason;
    public $ccType;
    public $goodsName;
    public $goodsDesc;
    public $realOrderId;
    public $useepayRes;
    public $useepayOrderNo;
    public $grandTotalAmount;
    public $payMethodResp;

    function __construct()
    {
        // Set default values.
        $this->command     = "sale";
        $this->result      = "Error";
        $this->resultcode  = "E";
        $this->error       = "Transaction not processed yet.";
        $this->timeout     = 45;
        $this->cardpresent = false;
        $this->lineitems   = array();
        if (isset($_SERVER['REMOTE_ADDR'])) $this->ip = $_SERVER['REMOTE_ADDR'];
        $this->software = "UseePay_UseePayApi v" . USEEPAYAPI_VERSION;
    }

    protected function _log($message, $level = null)
    {
        Mage::log($message, $level, 'useepayapi.log');
    }

    /**
     * Verify that all required data has been set
     *
     * @return string
     */
    function CheckData()
    {

        $this->amount = preg_replace('/[^\d.]+/', '', $this->amount);
        if (!$this->amount) return "Amount is required";
        if (!$this->invoice && !$this->orderid) return "Invoice number or Order ID is required";

        return 0;
    }

    function addLine($sku, $name, $description, $cost, $qty, $taxAmount, $url)
    {
        $this->lineitems[] = array(
            'sku'         => $sku,
            'name'        => $name,
            'description' => $description,
            'cost'        => $cost,
            'taxable'     => ($taxAmount > 0) ? 'Y' : 'N',
            'qty'         => $qty,
            'url'         => $url
        );
    }

    public function getIP()
    {
        if (array_key_exists("HTTP_X_FORWARDED_FOR", $_SERVER))
            $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
        else if (array_key_exists("HTTP_CLIENT_IP", $_SERVER))
            $ip = $_SERVER["HTTP_CLIENT_IP"];
        else if (array_key_exists("REMOTE_ADDR", $_SERVER))
            $ip = $_SERVER["REMOTE_ADDR"];
        else if (@getenv("HTTP_X_FORWARDED_FOR"))
            $ip = getenv("HTTP_X_FORWARDED_FOR");
        else if (@getenv("HTTP_CLIENT_IP"))
            $ip = getenv("HTTP_CLIENT_IP");
        else if (@getenv("REMOTE_ADDR"))
            $ip = getenv("REMOTE_ADDR");
        else
            $ip = "Unknown";
        $ip = explode(', ', $ip);
        $ip = $ip['0'];
        return $ip;
    }

    /**
     * Filter special characters
     * @param $str
     * @return mixed
     */
    public function filter($str)
    {
        return str_replace(
            ["<", ">", "'", "\"", "&"],
            ["", "", "", "", ""],
            trim($str)
        );
    }

    /**
     * price转成最小单位级别
     * @param $currency
     * @param $price
     * @return int
     */
    function convert_price($currency, $price, $times = 2)
    {
        $currency          = strtoupper($currency);
        $currency_map_json = '{"EUR":2,"AMD":2,"BOV":2,"XAF":0,"COP":2,"COU":2,"CUP":2,"ANG":2,"DOP":2,"HKD":2,"IRR":2,"NPR":2,"PYG":0,"QAR":2,"RON":2,"SBD":2,"SOS":2,"LKR":2,"TWD":2,"VUV":0,"XTS":0,"XAU":0,"AOA":2,"ARS":2,"BRL":2,"BGN":2,"KHR":2,"KMF":0,"CDF":2,"GNF":0,"HNL":2,"ISK":0,"ILS":2,"JPY":0,"KWD":3,"LBP":2,"LYD":3,"MWK":2,"MXV":2,"PKR":2,"RWF":0,"STD":2,"SLL":2,"CHW":2,"UGX":0,"USN":2,"UZS":2,"XBB":0,"BBD":2,"XOF":0,"BMD":2,"CAD":2,"NZD":2,"CZK":2,"FJD":2,"GBP":2,"ZAR":2,"LRD":2,"PHP":2,"WST":2,"SCR":2,"SDG":2,"TMT":2,"UYI":0,"XBA":0,"BAM":2,"BWP":2,"CLP":0,"CRC":2,"GYD":2,"JOD":3,"MKD":2,"MUR":2,"MDL":2,"MNT":2,"NGN":2,"SRD":2,"SEK":2,"TZS":2,"TOP":2,"UAH":2,"UYU":2,"ZWL":2,"USD":2,"BSD":2,"BYN":2,"BZD":2,"CLF":4,"GHS":2,"GTQ":2,"IQD":3,"KRW":0,"MOP":2,"MXN":2,"MAD":2,"NIO":2,"XSU":0,"SZL":2,"THB":2,"VND":0,"ZMW":2,"XPD":0,"AFN":2,"AUD":2,"BOB":2,"CNY":2,"HRK":2,"DJF":0,"EGP":2,"ETB":2,"GEL":2,"HTG":2,"XDR":0,"JMD":2,"KZT":2,"KPW":2,"MGA":2,"MVR":2,"XUA":0,"MMK":2,"NAD":2,"OMR":3,"PGK":2,"RUB":2,"TTD":2,"XXX":0,"ALL":2,"DZD":2,"XCD":2,"AZN":2,"BDT":2,"INR":2,"BTN":2,"NOK":2,"BND":2,"BIF":0,"CUC":2,"SVC":2,"FKP":2,"XPF":0,"GMD":2,"HUF":2,"KES":2,"KGS":2,"LAK":2,"MYR":2,"MRO":2,"PAB":2,"PEN":2,"RSD":2,"SGD":2,"CHE":2,"TND":3,"TRY":2,"VEF":2,"YER":2,"XBD":0,"XPT":0,"XAG":0,"AWG":2,"BHD":3,"CVE":2,"KYD":2,"DKK":2,"ERN":2,"GIP":2,"IDR":2,"LSL":2,"CHF":2,"MZN":2,"PLN":2,"SHP":2,"SAR":2,"SSP":2,"SYP":2,"TJS":2,"AED":2,"XBC":0}';
        $currency_map      = json_decode($currency_map_json, true);
        if (array_key_exists($currency, $currency_map)) {
            $times = $currency_map[$currency];
        }
        $price = round($price, $times);
        while ($times--) {
            $price *= 10;
        }
        return intval($price);
    }

    /**
     * Send transaction to the UseePay Gateway and parse response
     *
     * @return boolean
     */
    function Process()
    {
        if ($this->ccType == 'VI') {
            $this->ccType = 'VISA';
            return $this->ProcessUseePay();
        }
        if ($this->ccType == 'MC') {
            $this->ccType = 'MASTER';
            return $this->ProcessUseePay();
        }
        if ($this->ccType == 'JCB') {
            $this->ccType = 'JCB';
            return $this->ProcessUseePay();
        }
        if ($this->ccType == 'AE') {
            $this->ccType = 'American Express';
            return $this->ProcessUseePay();
        }
        if ($this->ccType == 'DI') {
            $this->ccType = 'Discover';
            return $this->ProcessUseePay();
        }
        return false;
    }

    function ProcessUseePay()
    {

        $tmp = $this->CheckData();

        if ($tmp) {
            $this->result     = "Error";
            $this->resultcode = "E";
            $this->error      = $tmp;
            $this->errorcode  = 10129;
            return false;
        }
        if (!is_array($this->lineitems)) $this->lineitems = array();
        foreach ($this->lineitems as $lineitem) {
            $this->goodsName .= $lineitem['name'] . "|";
            $this->goodsDesc .= $lineitem['name'] . "^^" . number_format($lineitem['qty'], 0) . "^" . number_format($lineitem['cost'], 2) . "^" . $lineitem['url'] . "|";
        }

        $this->goodsName = trim($this->goodsName, " |");
        $this->goodsDesc = trim($this->goodsDesc, " |");

        $mconfig       = Mage::getStoreConfig('payment/useepayapi');
        $currency_code = Mage::app()->getStore()->getCurrentCurrencyCode();
        $orderAmount   = $this->grandTotalAmount;
        //$orderAmount = round($orderAmount,2) * 100;
        $orderAmount = $this->convert_price($currency_code, $orderAmount, 2);

        $cardholderName      = explode("//", $this->cardholder);
        $cardholderFirstName = $cardholderName[0];
        $cardholderLastName  = $cardholderName[sizeof($cardholderName) - 1];

        //用户信息
        $customerUserInfo = Mage::getSingleton('customer/session')->getCustomer();

        $fingerPrintId = $_COOKIE["CO_XD_FP_ID"];

        $registrationTime = "";
        if ($customerUserInfo->created_at != "") {
            $registrationTime = date("YmdHis", strtotime($customerUserInfo->created_at));
        }
        $browserInfo = json_decode($_POST["browserInfo"], true);
        try {
            $payMethodInfo = array(
                //支付信息
                'cardNo'          => str_replace([" "], [""], trim($this->card)),
                'firstName'       => $cardholderFirstName,
                'lastName'        => $cardholderLastName,
                'expirationMonth' => substr($this->exp, 0, 2),
                'expirationYear'  => substr($this->exp, 2, 2),
                'cvv'             => $this->cvv2,
            );
            $payMethodInfo = json_encode($payMethodInfo);

            $shipStreet = $this->shipstreet;
            if ($this->shipstreet2) {
                $shipStreet .= " " . $this->shipstreet2;
            }
            $billStreet = $this->billstreet;
            if ($this->billstreet2) {
                $billStreet .= " " . $this->billstreet2;
            }
            // risk info
            $risk_info       = [
                'adjustmentFactor' => '',   //风险分数调整，可为负数
                'retryNum'         => '',   //商户在其他金融机构和在UseePay重试的总次数
                'trade'            => [
                    'code' => '5999', //贸易代码
                    'item' => [
                        'customerResource' => '',
                        'cust'             => [
                            'registrationIP' => ''
                        ],
                        'loginTime'        => '',
                        'loginIP'          => $this->getIP(),
                        'orderTime'        => '',
                        'payTime'          => date("YmdHis", time()),
                        'payIP'            => $this->getIP(),
                        'transSite'        => $mconfig['useepay_user_siteid'],
                        'logisticsMode'    => '',
                        'ship'             => [
                            'phoneNoLastModificationTime' => '',
                            'adressLastModificationTime'  => ''
                        ]
                    ],   //贸易参数集合
                ],
                'device'           => [
                    'fingerPrintId' => $fingerPrintId
                ],
                'cust'             => [
                    'registerUserId'   => '', // 用户在商户系统的id
                    'ip'               => $this->getIP(),  // 用户下单IP
                    'email'            => $this->email,     // 用户email
                    'phoneNum'         => $this->billphone, // 用户phone
                    'registrationTime' => $registrationTime, // 用户注册时间
                    'level'            => '', // 用户标识
                    'lastShoppingTime' => '', // 上次消费时间
                ],
                'ship'             => [
                    'phoneNo'    => $this->shipphone ? $this->shipphone : $this->billphone, // 收货联系电话
                    'firstName'  => $this->shipfname ? $this->shipfname : $this->billfname, // 收货人名
                    'lastName'   => $this->shiplname ? $this->shiplname : $this->billlname, // 收货人姓
                    'street'     => $shipStreet ? $shipStreet : $billStreet, // 收货人街道
                    'postalCode' => $this->shipzip ? $this->shipzip : $this->billzip, // 收货人邮政编码
                    'city'       => $this->shipcity ? $this->shipcity : $this->billcity, // 收货人城市
                    'state'      => strlen(trim($this->shipstate)) <= 0 ? ($this->shipcity ? $this->shipcity : $this->billcity) : $this->shipstate, // 收货人省份
                    'country'    => $this->shipcountry ? $this->shipcountry : $this->billcountry, // 收货人国家英文二字码
                ],
                'bill'             => [
                    'street'     => $billStreet, // 账单街道
                    'postalCode' => $this->billzip, // 账单邮政编码
                    'city'       => $this->billcity,   // 账单城市
                    'state'      => strlen(trim($this->billstate)) <= 0 ? $this->billcity : $this->billstate,  // 账单省份
                    'country'    => $this->billcountry, // 账单国家英文二字码
                ],
                "browser"          => [
                    "acceptHeader"   => "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8",
                    "javaEnabled"    => $browserInfo["javaEnabled"],
                    "screenHeight"   => $browserInfo["screenHeight"],
                    "screenWidth"    => $browserInfo["screenWidth"],
                    "timeZoneOffset" => $browserInfo["timeZoneOffset"],
                    "language"       => $browserInfo["language"],
                    "userAgent"      => $browserInfo["userAgent"],
                    "colorDepth"     => $browserInfo["colorDepth"]
                ]
            ];
            $risk_info_goods = [];
            foreach ($this->lineitems as $product) {
                $temp              = [
                    'sku'       => strval($this->filter($product['sku'])),
                    'itemPrice' => strval($product['cost']),
                    'quantity'  => strval($product['qty']),
                ];
                $risk_info_goods[] = $temp;
            }
            $risk_info['goods'] = $risk_info_goods;
            // buried
            $xidataBehaviorResult = $_POST["_xidataBehaviorResult"];
            $xidataBehaviorResult = ltrim($xidataBehaviorResult, ",");
            $xidataBehaviorResult = explode(",", $xidataBehaviorResult);
            $behaviorData         = [];
            foreach ($xidataBehaviorResult as $k => $v) {
                $k              = $k + 1;
                $res            = [
                    'code' => "$k",
                    'item' => $v
                ];
                $behaviorData[] = $res;
            }
            $risk_info['buried'] = $behaviorData;
            $risk_info_json      = json_encode($risk_info);
            Mage::log("****  notifyUrl is:" . $risk_info_json . " ****\n", null, "UseePay.log");
            //基本参数+业务参数
            $param = array(
                'version'        => '2.0',
                'transType'      => 'sale',
                'accessType'     => 's2s',
                'transId'        => $this->orderid,
                'transChannel'   => 'credit_card',
                'payMethod'      => $mconfig['useepay_pay_method'],
                'deviceChannel'  => 'browser',
                'payMethodInfo'  => $payMethodInfo,
                //'riskInfo' => $risk_info_json,
                'riskInfo'       => $risk_info_json,
                'transTimeout'   => $mconfig['useepay_trans_timeout'],
                //'goodsName' => mb_substr($this->goodsName,0,512,'utf-8'),
                'goodsName'      => str_replace(
                    ["\r", "\n", "\r\n"],
                    [" ", " ", " "],
                    trim($this->goodsName)
                ),
                //'goodsInfo' => mb_substr($this->goodsDesc,0,2000,'utf-8'),
                'goodsInfo'      => str_replace(
                    ["\r", "\n", "\r\n"],
                    [" ", " ", " "],
                    trim($this->goodsDesc)
                ),
                'carrierId'      => $mconfig['useepay_user_siteid'],
                'transAmt'       => $orderAmount,
                'dcc'            => '',
                'currency'       => $currency_code,
                'settleCurrency' => '',
                'subAccountData' => '',
                'notifyUrl'      => Mage::getUrl('useepayapi/UseePay/notify/'),
                'redirectUrl'    => Mage::getUrl('checkout/onepage/return/'),
                'reqReserved'    => $this->useepaySession,
                //'reserved' => 'magento1.9-api2.0',
                'reserved'       => json_encode(array(
                    'pluginName'    => 'magento-api',
                    'pluginVersion' => '1.9',
                    'origVersion'   => '2.0'
                )),
                'merchantId'     => $mconfig['useepay_user_id'],
                'charset'        => 'UTF-8',
                'signType'       => 'MD5',
                'sign'           => '',
            );
            if ($mconfig['useepay_pay_method'] != 'normal') {
                $param["threeDSType"] = '2.0';
            }

            ksort($param);
            $signStr = '';
            Mage::log("****  notifyUrl is:" . Mage::getUrl('useepayapi/UseePay/notify/') . " ****\n", null, "UseePay.log");
            foreach ($param as $key => $value) {
                $v = trim($value);
                if (strlen($v) > 0) $signStr .= '&' . $key . '=' . $v;
// 				Mage::log ( "$key=$value" , null, "UseePay.log" );
            }

            $signStr = substr($signStr, 1);
            Mage::log(" === signStr is:" . $signStr, null, "UseePay.log");
            $signStr .= "&pkey=" . $mconfig['useepay_user_key'];

            if ($param['signType'] == 'MD5') {
                $param['sign'] = strtolower(md5($signStr));
            }
            Mage::log("** sign is :" . $param['sign'], null, "UseePay.log");

        } catch (Exception $e1) {
            Mage::log(" Exception is :" . $e1, null, "UseePay.log");
        }

        $server_url = $mconfig['gateway_url'];
        Mage::log("****  server_url is:" . $server_url . " ****\n", null, "UseePay.log");
        try {
            if (ini_get("default_socket_timeout") < 120) ini_set("default_socket_timeout", 120);
            $httpClient = new Varien_Http_Client();
            $httpClient->setUri($server_url);
            $httpClient->setConfig(array('timeout' => 30));
            $httpClient->setParameterPost($param);
            $httpClient->setMethod('POST');

            $responseBody = $httpClient->request()->getBody();
            Mage::log("****  responseBody is:" . $responseBody . " ****", null, "UseePay.log");

            $response = json_decode($responseBody, true);

            ksort($response);
            Mage::log('*****************acquiring result code of synchronized is :' . json_encode($response) . '******************\n', null, "UseePay.log");
            $signStr = '';
            $mysign  = '';
            foreach ($response as $key => $value) {
                if ('' !== $value && 'sign' !== $key) $signStr .= '&' . $key . '=' . $value;
// 				Mage::log ( "$key ==> $value", null, "UseePay.log" );
            }
            $signStr    = substr($signStr, 1);
            $signParams = $signStr; // for log
            $signStr    .= "&pkey=" . $mconfig['useepay_user_key'];

            if ($response['signType'] == 'MD5') {
                $mysign = strtolower(md5($signStr));
            }
            Mage::log(" ===verifying signStr is :" . $signParams, null, "UseePay.log");
            Mage::log("** verifying sign is :" . $mysign, null, "UseePay.log");

//			Mage::log ( "********acquiring result code of synchronized is : " . $response . "********", null, "UseePay.log" );

            if ($mysign == $response ["sign"]) {
                if ("success" == $response['status']) {
                    $this->resultcode     = "S";
                    $this->useepayOrderNo = $response['orderId'];
                    //return true;
                } elseif ('pending' == $response['status']) {
                    $this->result         = "pending";
                    $this->resultcode     = "G";
                    $this->errorcode      = $response['respCode'];
                    $this->error          = $response['respMsg'];
                    $this->useepayOrderNo = $response['orderId'];
                    if ($response['respCode'] == "3200") {
                        $this->payMethodResp = $response["payMethodResp"];
                    }
                } else {
                    $this->result         = "Error";
                    $this->resultcode     = "F";
                    $this->error          = $response['respMsg'];
                    $this->errorcode      = $response['respCode'];
                    $this->useepayOrderNo = $response['orderId'];
                    //return false;
                }
            } else {
                Mage::log("CheckSignFail:" . $signParams, null, "UseePay.log");
                $this->resultcode = "F";
            }
        } catch (Exception $e) {
            Mage::log("********exception occurs when requesting, order id :" . "  " . $this->orderid . " " . $e . "********", null, "UseePay.log");
            $this->resultcode = "E";
        }
        Mage::log("********acquiring result code of synchronized is : " . $response['respCode'] . "********", null, "UseePay.log");
    }

    function xmlentities($string)
    {
        // $string = preg_replace('/[^a-zA-Z0-9 _\-\.\'\r\n]/e', '_uePrivateXMLEntities("$0")', $string);
        $string = preg_replace_callback('/[^a-zA-Z0-9 _\-\.\'\r\n]/', array('self', '_xmlEntitesReplaceCallback'), $string);
        return $string;
    }

    static protected function _xmlEntitesReplaceCallback($matches)
    {
        return self::_uePrivateXMLEntities($matches[0]);
    }

    static protected function _uePrivateXMLEntities($char)
    {
        $chars = array(
            128 => '&#8364;',
            130 => '&#8218;',
            131 => '&#402;',
            132 => '&#8222;',
            133 => '&#8230;',
            134 => '&#8224;',
            135 => '&#8225;',
            136 => '&#710;',
            137 => '&#8240;',
            138 => '&#352;',
            139 => '&#8249;',
            140 => '&#338;',
            142 => '&#381;',
            145 => '&#8216;',
            146 => '&#8217;',
            147 => '&#8220;',
            148 => '&#8221;',
            149 => '&#8226;',
            150 => '&#8211;',
            151 => '&#8212;',
            152 => '&#732;',
            153 => '&#8482;',
            154 => '&#353;',
            155 => '&#8250;',
            156 => '&#339;',
            158 => '&#382;',
            159 => '&#376;'
        );
        $num   = ord($char);
        return (($num > 127 && $num < 160) ? $chars[$num] : "&#" . $num . ";");
    }
}

function _uePrivateXMLEntities($num)
{
    $chars = array(
        128 => '&#8364;',
        130 => '&#8218;',
        131 => '&#402;',
        132 => '&#8222;',
        133 => '&#8230;',
        134 => '&#8224;',
        135 => '&#8225;',
        136 => '&#710;',
        137 => '&#8240;',
        138 => '&#352;',
        139 => '&#8249;',
        140 => '&#338;',
        142 => '&#381;',
        145 => '&#8216;',
        146 => '&#8217;',
        147 => '&#8220;',
        148 => '&#8221;',
        149 => '&#8226;',
        150 => '&#8211;',
        151 => '&#8212;',
        152 => '&#732;',
        153 => '&#8482;',
        154 => '&#353;',
        155 => '&#8250;',
        156 => '&#339;',
        158 => '&#382;',
        159 => '&#376;');
    $num   = ord($num);
    return (($num > 127 && $num < 160) ? $chars[$num] : "&#" . $num . ";");
}
