<?php
require_once './app/code/local/UseePay/UseePayApi/Helper/ConfigHelper.php';
require_once './app/code/local/UseePay/UseePayApi/Helper/SignatureHelper.php';

class UseePay_UseePayApi_SyncResultController extends Mage_Core_Controller_Front_Action
{
    public function indexAction()
    {
        if (!$this->getRequest()->isPost()) {
            return;
        }
        $data   = [];
        $result = json_decode($this->getRequest()->getParam('result'), true);
        if (SignatureHelper::verifyMd5Signature($result, ConfigHelper::getMd5SecretKey())) {
            $order = Mage::getModel('sales/order')->loadByIncrementId($result['transactionId']);
            $status_history = $order->getStatus();

            if ('succeed' == $result['resultCode']) {
                // success
                if (empty($status_history) || $status_history != Mage_Sales_Model_Order::STATE_PROCESSING) {
                    $order->setTotalPaid($order->getGrandTotal());
                    $order->addStatusHistoryComment('UseePay order no : ' . $result['reference']);
                    $order->setStatus(Mage_Sales_Model_Order::STATE_PROCESSING);
                    $order->addStatusToHistory(Mage_Sales_Model_Order::STATE_PROCESSING, Mage::helper('paygate')->__('UseePay order processing completed.'));
                    $order->save();
                }
                $data['success']     = 'true';
                $data['message']     = 'payment is successful.';
                $data['redirectUrl'] = Mage::getUrl('sales/order/view/order_id/' . $order->getId());
                Mage::getSingleton('checkout/session')->clear();
            } elseif ('failed' == $result['resultCode'] || 'closed' == $result['resultCode'] || 'cancelled' == $result['resultCode']) {
                // failed
                if (empty($status_history) || $status_history != Mage_Sales_Model_Order::STATE_CANCELED) {
                    $order->addStatusHistoryComment('UseePay order no : ' . $result['reference']);
                    $order->addStatusToHistory(Mage_Sales_Model_Order::STATE_CANCELED, Mage::helper('paygate')->__('UseePay order processing failed.'));
                    $order->setStatus(Mage_Sales_Model_Order::STATE_CANCELED);
                    $order->save();
                }
                $data['success'] = 'false';
                $data['message'] = 'payment failed! Result Message is: ' . $result["errorMsg"];
            } else {
                // pending
                $order->addStatusHistoryComment('UseePay order no : ' . $result['reference']);
                $order->addStatusToHistory('pending', Mage::helper('paygate')->__('UseePay order processing completed,  waiting for asynchronous notification.'));
                $order->setStatus('pending');
                $order->setState('pending');
                $order->save();
                $data['success']     = 'true';
                $data['message']     = 'payment is processing,  Result Message is: ' . $result["errorMsg"];
                $data['redirectUrl'] = Mage::getUrl('sales/order/view/order_id/' . $order->getId());
                Mage::getSingleton('checkout/session')->clear();
            }
        } else {
            $data['success'] = 'false';
            $data['message'] = 'Invalid signature';
        }
        $this->getResponse()->setHttpResponseCode(200)->setBody(json_encode($data, true));
    }
}