<?php


require_once './app/code/local/UseePay/UseePayApi/Helper/ConfigHelper.php';
require_once './app/code/local/UseePay/UseePayApi/Helper/CurrencyHelper.php';
require_once './app/code/local/UseePay/UseePayApi/Helper/SignatureHelper.php';

class UseePay_UseePayApi_TokenController extends Mage_Core_Controller_Front_Action
{
    public function indexAction()
    {
        if (!$this->getRequest()->isPost()) {
            return;
        }
        $params = $this->buildRequestParams(false);
        $data   = [];
        try {
            $result = json_decode($this->sendRequest(ConfigHelper::getEndpoint(), $params), true);
            if (!empty($result) && is_array($result) && !empty($result['token'])) {
                if (SignatureHelper::verifyMd5Signature($result, ConfigHelper::getMd5SecretKey())) {
                    $data['success'] = true;
                    $data['token']   = $result['token'];
                } else {
                    $data['success'] = false;
                    $data['message'] = 'Invalid signature';
                }
            } else {
                if ($result['errorCode'] == 1100) {
                    $params = $this->buildRequestParams(true);
                    $result = json_decode($this->sendRequest(ConfigHelper::getEndpoint(), $params), true);
                    if (!empty($result) && is_array($result) && !empty($result['token'])) {
                        if (SignatureHelper::verifyMd5Signature($result, ConfigHelper::getMd5SecretKey())) {
                            $data['success'] = true;
                            $data['token']   = $result['token'];
                        } else {
                            $data['success'] = false;
                            $data['message'] = 'Invalid signature';
                        }
                    } else {
                        $data['success'] = false;
                        $data['message'] = $result['errorMsg'];
                    }
                } else {
                    $data['success'] = false;
                    $data['message'] = $result['errorMsg'];
                }
            }
        } catch (\Exception $e) {
            $data['success'] = false;
            $data['message'] = 'Network error, please try later!';
        }
        $this->getResponse()->setHttpResponseCode(200)->setBody(json_encode($data, true));

    }

    private function buildRequestParams($retry)
    {
        $quote = Mage::getSingleton('checkout/session')->getQuote();

        $quote->getPayment()->importData(array('method' => 'useepayapi'));
        $quote->collectTotals();

        $order = Mage::getModel('sales/order')->loadByIncrementId($quote->getReservedOrderId());
        if ($retry || empty($order) || empty($order->getId())) {
            $service = Mage::getModel('sales/service_quote', $quote);
            $quote->reserveOrderId()->save();
            $order = $service->submit();
        }

        $orderShippingAddress = $quote->getShippingAddress();
        $orderBillingAddress  = $quote->getBillingAddress();

        $billingAddress  = [];
        $shippingAddress = [];

        if (!empty($orderBillingAddress)) {
            if (sizeof($orderBillingAddress->getStreet()) > 1) {
                $billingAddress['houseNo'] = $orderBillingAddress->getStreet()[1];
            } else {
                $billingAddress['houseNo'] = '';
            }
            if (sizeof($orderBillingAddress->getStreet()) > 0) {
                $billingAddress['street'] = $orderBillingAddress->getStreet()[0];
            } else {
                $billingAddress['street'] = '';
            }
            $billingAddress['email']      = $orderBillingAddress->getEmail();
            $billingAddress['phoneNo']    = $orderBillingAddress->getTelephone();
            $billingAddress['firstName']  = $orderBillingAddress->getFirstname();
            $billingAddress['lastName']   = $orderBillingAddress->getLastname();
            $billingAddress['postalCode'] = $orderBillingAddress->getPostcode();
            $billingAddress['city']       = $orderBillingAddress->getCity();
            $billingAddress['state']      = $orderBillingAddress->getRegion();
            $billingAddress['country']    = $orderBillingAddress->getCountryId();
        }

        if (!empty($orderShippingAddress)) {
            if (sizeof($orderShippingAddress->getStreet()) > 1) {
                $shippingAddress['houseNo'] = $orderShippingAddress->getStreet()[1];
            } else {
                $shippingAddress['houseNo'] = '';
            }
            if (sizeof($orderShippingAddress->getStreet()) > 0) {
                $shippingAddress['street'] = $orderShippingAddress->getStreet()[0];
            } else {
                $shippingAddress['street'] = '';
            }
            $shippingAddress['email']      = $orderShippingAddress->getEmail();
            $shippingAddress['phoneNo']    = $orderShippingAddress->getTelephone();
            $shippingAddress['firstName']  = $orderShippingAddress->getFirstname();
            $shippingAddress['lastName']   = $orderShippingAddress->getLastname();
            $shippingAddress['postalCode'] = $orderShippingAddress->getPostcode();
            $shippingAddress['city']       = $orderShippingAddress->getCity();
            $shippingAddress['state']      = $orderShippingAddress->getRegion();
            $shippingAddress['country']    = $orderShippingAddress->getCountryId();

            if (!isset($billingAddress)) {
                if (sizeof($orderShippingAddress->getStreet()) > 1) {
                    $billingAddress['houseNo'] = $orderShippingAddress->getStreet()[0];
                } else {
                    $billingAddress['houseNo'] = '';
                }
                if (sizeof($orderShippingAddress->getStreet()) > 0) {
                    $billingAddress['street'] = $orderShippingAddress->getStreet()[1];
                } else {
                    $billingAddress['street'] = '';
                }
                $billingAddress['email']      = $orderShippingAddress->getEmail();
                $billingAddress['phoneNo']    = $orderShippingAddress->getTelephone();
                $billingAddress['firstName']  = $orderShippingAddress->getFirstname();
                $billingAddress['lastName']   = $orderShippingAddress->getLastname();
                $billingAddress['postalCode'] = $orderShippingAddress->getPostcode();
                $billingAddress['city']       = $orderShippingAddress->getCity();
                $billingAddress['state']      = $orderShippingAddress->getRegion();
                $billingAddress['country']    = $orderShippingAddress->getCountryId();
            }
        }

        $payerInfo = json_encode([
            'paymentMethod'       => 'credit_card',
            'authorizationMethod' => 'cvv',
            'billingAddress'      => $billingAddress

        ]);

        $userInfo = json_encode(
            [
                'email'   => $quote->getCustomerEmail(),
                'phoneNo' => empty($billingAddress['phoneNo']) ? $shippingAddress['phoneNo'] : $billingAddress['phoneNo'],
                'ip'      => $quote->getRemoteIp()
            ]
        );

        $productList = $this->getProductItems($order->getAllItems());
        $subject     = '';
        foreach ($productList as $product) {
            $subject .= $product['name'];
        }

        $orderInfo = json_encode([
            'subject'         => $subject,
            'goodsInfo'       => $productList,
            'shippingAddress' => $shippingAddress
        ]);


        $params         = [
            'version'                   => '1.0',
            'merchantNo'                => ConfigHelper::getMerchantNo(),
            'transactionType'           => 'pay',
            'transactionId'             => $order->getIncrementId(),
            'transactionExpirationTime' => '30',
            'appId'                     => ConfigHelper::getAppId(),
            'currency'                  => $order->getOrderCurrencyCode(),
            'amount'                    => CurrencyHelper::convertPriceToUseePayPrice($order->getOrderCurrencyCode(), $order->getGrandTotal()),
            'country'                   => $order->getBillingAddress()->getCountryId(),
            'language'                  => 'en',
            'notifyUrl'                 => Mage::getUrl('useepayapi/asyncResult'),
            'terminalType'              => $this->getTerminalType(),
            'reserved'                  => json_encode([
                'pluginName'    => 'Magento1.9',
                'pluginVersion' => '1.0'
            ]),
            'charset'                   => 'utf-8',
            'signType'                  => 'MD5',
            'payerInfo'                 => $payerInfo,
            'userInfo'                  => $userInfo,
            'orderInfo'                 => $orderInfo,
            'autoRedirect'              => 'false'
        ];
        $params['sign'] = SignatureHelper::createMd5Signature($params, ConfigHelper::getMd5SecretKey());
        return $params;

    }

    private function getProductItems($allItems)
    {
        $productDetails = [];

        foreach ($allItems as $item) {
            $tmp              = [];
            $tmp['name']      = $item->getName();
            $tmp['quantity']  = intval($item->getQtyOrdered());
            $tmp['price']     = $item->getPrice();
            $productDetails[] = $tmp;
        }
        return $productDetails;
    }

    private function getTerminalType()
    {
        $terminalType = 'WEB';
        $useragent    = $_SERVER['HTTP_USER_AGENT'];
        if (preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i', $useragent) || preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i', substr($useragent, 0, 4))) {
            $terminalType = 'H5';
        }
        return $terminalType;
    }

    private function sendRequest($url, $data)
    {
        $curl_cookie = '';
        foreach ($_COOKIE as $key => $value) {
            $curl_cookie .= $key . '=' . $value . ';';
        }
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_TIMEOUT, 300);
        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_COOKIE, $curl_cookie);
        $tmpInfo = curl_exec($curl);
        curl_close($curl);
        return $tmpInfo;
    }
}