<?php
class UseePay_UseePayApi_UseePayController extends Mage_Core_Controller_Front_Action {
	public function createInvoice($order) {
		try {
			$savedQtys = array ();
			$invoice = Mage::getModel ( 'sales/service_order', $order )->prepareInvoice ( $savedQtys );
			Mage::register ( 'current_invoice', $invoice );
			$invoice->register ();
// 			$invoice->setEmailSent ( true );
			$invoice->getOrder ()->setCustomerNoteNotify ( true );
			$invoice->getOrder ()->setIsInProcess ( true );
			$transactionSave = Mage::getModel('core/resource_transaction')
                    ->addObject($invoice)
                    ->addObject($invoice->getOrder());
			$invoice->setState ( "2" );
			$invoice->setCanVoidFlag ( false );
			$invoice->pay ();
			$transactionSave->save ();
			$invoice->sendEmail ( true, "" );
			
			if ($invoice->getEmailSent()) {
				$order->addStatusToHistory(Mage_Sales_Model_Order::STATE_PROCESSING, Mage::helper ( 'paygate' )->__( 'Invoice #' . $invoice->getIncrementId() . ' is notified to customer.' ), true );
				$order->save();
			}
		} catch ( Exception $e ) {
			Mage::logException ( $e );
			echo print_r ( $e );
		}
	}

    /**
     * price转成最小单位级别
     * @param $currency
     * @param $price
     * @return int
     */
    function convert_price($currency, $price, $times = 2)
    {
        $currency = strtoupper($currency);
        $currency_map_json = '{"EUR":2,"AMD":2,"BOV":2,"XAF":0,"COP":2,"COU":2,"CUP":2,"ANG":2,"DOP":2,"HKD":2,"IRR":2,"NPR":2,"PYG":0,"QAR":2,"RON":2,"SBD":2,"SOS":2,"LKR":2,"TWD":2,"VUV":0,"XTS":0,"XAU":0,"AOA":2,"ARS":2,"BRL":2,"BGN":2,"KHR":2,"KMF":0,"CDF":2,"GNF":0,"HNL":2,"ISK":0,"ILS":2,"JPY":0,"KWD":3,"LBP":2,"LYD":3,"MWK":2,"MXV":2,"PKR":2,"RWF":0,"STD":2,"SLL":2,"CHW":2,"UGX":0,"USN":2,"UZS":2,"XBB":0,"BBD":2,"XOF":0,"BMD":2,"CAD":2,"NZD":2,"CZK":2,"FJD":2,"GBP":2,"ZAR":2,"LRD":2,"PHP":2,"WST":2,"SCR":2,"SDG":2,"TMT":2,"UYI":0,"XBA":0,"BAM":2,"BWP":2,"CLP":0,"CRC":2,"GYD":2,"JOD":3,"MKD":2,"MUR":2,"MDL":2,"MNT":2,"NGN":2,"SRD":2,"SEK":2,"TZS":2,"TOP":2,"UAH":2,"UYU":2,"ZWL":2,"USD":2,"BSD":2,"BYN":2,"BZD":2,"CLF":4,"GHS":2,"GTQ":2,"IQD":3,"KRW":0,"MOP":2,"MXN":2,"MAD":2,"NIO":2,"XSU":0,"SZL":2,"THB":2,"VND":0,"ZMW":2,"XPD":0,"AFN":2,"AUD":2,"BOB":2,"CNY":2,"HRK":2,"DJF":0,"EGP":2,"ETB":2,"GEL":2,"HTG":2,"XDR":0,"JMD":2,"KZT":2,"KPW":2,"MGA":2,"MVR":2,"XUA":0,"MMK":2,"NAD":2,"OMR":3,"PGK":2,"RUB":2,"TTD":2,"XXX":0,"ALL":2,"DZD":2,"XCD":2,"AZN":2,"BDT":2,"INR":2,"BTN":2,"NOK":2,"BND":2,"BIF":0,"CUC":2,"SVC":2,"FKP":2,"XPF":0,"GMD":2,"HUF":2,"KES":2,"KGS":2,"LAK":2,"MYR":2,"MRO":2,"PAB":2,"PEN":2,"RSD":2,"SGD":2,"CHE":2,"TND":3,"TRY":2,"VEF":2,"YER":2,"XBD":0,"XPT":0,"XAG":0,"AWG":2,"BHD":3,"CVE":2,"KYD":2,"DKK":2,"ERN":2,"GIP":2,"IDR":2,"LSL":2,"CHF":2,"MZN":2,"PLN":2,"SHP":2,"SAR":2,"SSP":2,"SYP":2,"TJS":2,"AED":2,"XBC":0}';
        $currency_map = json_decode($currency_map_json, true);
        if (array_key_exists($currency, $currency_map)) {
            $times = $currency_map[$currency];
        }
        $price = round($price,$times);
        while ($times--) {
            $price *= 10;
        }
        return intval($price);
    }

	public function notifyAction() {
        Mage::log("接受到来自UseePay的异步通知", null, "UseePay.log");
		if ($this->getRequest ()->isPost ()) {
			$config = Mage::getStoreConfig ( 'payment/useepayapi' );
			//$postData = $this->getRequest ()->getPost ();
            $postData = $_POST;
			$method = 'post';
			$partner = $config ['useepay_user_id'];
			$security_code = $config ['useepay_user_key'];
			ksort($postData);
            Mage::log ( '*****************post from UseePay notify******************'.json_encode($postData).'******************\n', null, "UseePay.log" );
			$signStr='';
			$mysign='';
			foreach ($postData as $key => $value) {
				if ('' !== $value && 'sign' !== $key) $signStr .= '&' . $key . '=' . $value;
// 				Mage::log ( "$key ==> $value", null, "UseePay.log" );
			}
			$signStr=substr($signStr, 1);
			$signParams = $signStr; // for log
			$signStr .= "&pkey=".$security_code;
			
			if($postData['signType']=='MD5'){
				$mysign = strtolower(md5($signStr));
			}
 			Mage::log ( " ===verifying signStr is :" . $signParams , null, "UseePay.log" );
			Mage::log ( "** verifying sign is :" . $mysign , null, "UseePay.log" );
            if ($mysign == $postData ["sign"]) {
				$order = Mage::getModel ( 'sales/order' );
				Mage::log ( 'orderId is ' . $postData ['transId'], null, "UseePay.log" );

				for($i=0; $i<4; $i++){
					sleep(3);
					$realOrderId = $order->loadByIncrementId($postData['transId'])->getRealOrderId();
					if($realOrderId) break;
				}

				$ext1Rtn = $postData ["reqReserved"];
				$stateFromUseePay = $postData ["respCode"];

				if ($realOrderId) {
					$ext1 = $order->getPayment()->getCcSsIssue();

					if($ext1 != $ext1Rtn) {
 						Mage::log ( 'Different reqReserved of OrderId '. $realOrderId . ': ' . $ext1 . ' in sys, ' . $ext1Rtn . ' from UseePay.', null, "UseePay.log" );
 						echo 'OK';
					} else {
						$currency_code = $postData['currency'];
						$currentOrderAmount = $order->getGrandTotal();
						//$currentOrderAmount = round($currentOrderAmount, 2) * 100;
                        $currentOrderAmount = $this->convert_price($currency_code, $currentOrderAmount, 2);
						$useepayOrderAmount = intval ($postData["transAmt"] );
						Mage::log ( "order amount from DB is :" . $currentOrderAmount, null, "UseePay.log" );
						Mage::log ( "order amount from UseePay is :" . $useepayOrderAmount, null, "UseePay.log" );
						//$currentOrderAmounts = "$currentOrderAmount";
						if ($useepayOrderAmount != $currentOrderAmount) {
							Mage::log ( "order amount is not equal to UseePay order amount", null, "UseePay.log" );
							header( "HTTP/1.1 901 Handling failed",true, 901);
							echo 'orderAmount is Wrong';
							exit ();
						}
						$mstate = $order->getState ();
						Mage::log ( "order state from DB is " . $mstate, null, "UseePay.log" );

                        if ('success' == $postData ["status"]) {
                            if (Mage_Sales_Model_Order::STATE_PROCESSING != $mstate) {
                                $order->setState ( Mage_Sales_Model_Order::STATE_PROCESSING );
                                $order->setStatus ( Mage_Sales_Model_Order::STATE_PROCESSING );
                                $order->addStatusToHistory ( Mage_Sales_Model_Order::STATE_PROCESSING, Mage::helper ( 'paygate' )->__ ( 'Transaction is paid successfully.' ) );
                                try {
                                    $order->save ();
                                    $this->createInvoice ( $order );
                                    echo 'OK';
                                } catch ( Exception $e ) {
                                    Mage::log ( 'Save Order Exception 0000: ' . $e, null, "UseePay.log" );
                                    header( "HTTP/1.1 901 Handling failed",true, 901);
                                    echo 'Save Order Exception:' . $e;
                                    exit ();
                                }
                            } else {
                                echo 'OK';
                            }
                        } elseif ('failed' == $postData ["status"] || 'expired' == $postData ["status"] || 'canceled' == $postData ["status"]) {
                            if (Mage_Sales_Model_Order::STATE_CLOSED != $mstate && Mage_Sales_Model_Order::STATE_PROCESSING != $mstate) {
                                $order->setData ( 'state', Mage_Sales_Model_Order::STATE_CLOSED );
                                $order->setData ( 'status', Mage_Sales_Model_Order::STATE_CLOSED );
                                $order->addStatusToHistory ( Mage_Sales_Model_Order::STATE_CLOSED, Mage::helper ( 'paygate' )->__ ( 'UseePayApi acquiring failed(' . $postData ['respCode'] . ':' . $postData ['respMsg'] . ').' ) );
                                try {
                                    $order->save ();
                                    echo 'OK';
                                } catch ( Exception $e ) {
                                    Mage::log ( 'Save Order Exception ' . $stateFromUseePay . ": " . $e, null, "UseePay.log" );
                                    header( "HTTP/1.1 901 Handling failed",true, 901);
                                    echo 'Save Order Exception:' . $e;
                                    exit ();
                                }
                            } else {
                                echo 'OK';
                            }
                        } else {
                            echo 'OK';
                        }
					}

				} else {
					$mconfig = Mage::getStoreConfig ( 'payment/useepayapi' );
					if ('0000' !== $stateFromUseePay && ! $mconfig ['save_fail_order']) {
						echo 'OK';
					} else {
						Mage::log ( "Order is not create.", null, "UseePay.log" );
						header( "HTTP/1.1 901 Handling failed",true, 901);
						echo 'Order is not create.';
						exit ();
					}
				}
			} else {
				Mage::log ( "CheckSignFail:" . $signParams, null, "UseePay.log" );
				header( "HTTP/1.1 901 Handling failed",true, 901);
				echo 'Check sign fail.';
				exit ();
			}
		} else {
			Mage::log ( 'Method is not post', null, "UseePay.log" );
			header( "HTTP/1.1 901 Handling failed",true, 901);
			echo 'Method is not post';
			exit ();
		}
	}
}