<?php
namespace UseePay\Afterpay\Block\Payment;

use Magento\Checkout\Exception;

class Redirect extends \Magento\Framework\View\Element\Template
{
    /**
     * @var \Magento\Checkout\Model\Session
     */
    protected $_checkoutSession;
    protected $_paymentMethod;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \UseePay\Afterpay\Model\PaymentMethod $paymentMethod,
        \Magento\Checkout\Model\Session $checkoutSession,
        array $data = []
    )
    {
        $this->_checkoutSession = $checkoutSession;
        parent::__construct($context, $data);
        $this->_paymentMethod = $paymentMethod;
        $this->_isScopePrivate = true;
    }


    public function getCheckoutForm()
    {
        $parameter = $this->_paymentMethod->getCheckoutParameter();
        $gatewayUrl = $this->_paymentMethod->getGatewayUrl();
        $url = $this->_paymentMethod->getPageFailureUrl();
        try {
            $responseBody = $this->sendRequest($gatewayUrl, $parameter);
            $this->_paymentMethod->saveLog('responseBody is:'.$responseBody);
            $response = json_decode($responseBody,true);
            if (empty($response['redirectUrl'])) {
                $this->_paymentMethod->updateOrderFail($parameter['transactionId'], $response);
            } else {
                $url = $response['redirectUrl'];
            }
        } catch (\Exception $e) {
            $this->_paymentMethod->saveLog('exception is:'. $e->getMessage());
            $this->_paymentMethod->updateOrderFail($parameter['transactionId'], array());
        }
        return $url;
    }

    public function getPayMode()
    {
        $terminalType = $this->_paymentMethod->getTerminalType();
        if ('WEB' == $terminalType) {
            return 'iframe';
        }
        return 'redirect';

    }

    protected function sendRequest($url, $data)
    {
        $curl_cookie = '';
        foreach ($_COOKIE as $key => $value) {
            $curl_cookie .= $key . '=' . $value . ';';
        }
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_TIMEOUT, 300);
        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_COOKIE, $curl_cookie);
        $tmpInfo = curl_exec($curl);
        curl_close($curl);
        return $tmpInfo;
    }

}
