<?php

namespace UseePay\Applepay\Controller\Payment;


use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use UseePay\Applepay\Helper\OrderStatusHelper;
use UseePay\Applepay\service\LockService;
use UseePay\Applepay\service\InvoiceService;

class Back extends \Magento\Framework\App\Action\Action implements CsrfAwareActionInterface
{

    const BrowserReturn = "[Browser Return]";

    protected $_processingArray = array('processing', 'complete');


    /**
     * Customer session model
     *
     * @var \Magento\Customer\Model\Session
     */
    protected $_customerSession;
    protected $checkoutSession;
    protected $orderRepository;
    protected $_scopeConfig;
    protected $_orderFactory;
    protected $creditmemoSender;
    protected $orderSender;
    protected $urlBuilder;
    /**
     * @var \Magento\Quote\Api\CartRepositoryInterface
     */
    protected $quoteRepository;
    protected $lockService;

    /**
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Customer\Model\Session $customerSession
     */
    public function __construct(
        \Magento\Customer\Model\Session                          $customerSession,
        \Magento\Framework\App\Action\Context                    $context,
        \UseePay\Applepay\Model\PaymentMethod                   $paymentMethod,
        \Magento\Sales\Api\OrderRepositoryInterface              $orderRepository,
        \Magento\Sales\Model\OrderFactory                        $orderFactory,
        \Magento\Checkout\Model\Session                          $checkoutSession,
        \Magento\Sales\Model\Order\Email\Sender\CreditmemoSender $creditmemoSender,
        \Magento\Sales\Model\Order\Email\Sender\OrderSender      $orderSender,
        \Magento\Framework\Url                                   $urlBuilder,
        \Magento\Framework\App\Config\ScopeConfigInterface       $scopeConfig,
        \Magento\Quote\Api\CartRepositoryInterface               $quoteRepository,
        LockService               $lockService,
        InvoiceService               $invoiceService
    )
    {
        $this->_customerSession = $customerSession;
        $this->checkoutSession = $checkoutSession;
        $this->urlBuilder = $urlBuilder;
        $this->orderRepository = $orderRepository;
        parent::__construct($context);
        $this->_scopeConfig = $scopeConfig;
        $this->_orderFactory = $orderFactory;
        $this->_paymentMethod = $paymentMethod;
        $this->creditmemoSender = $creditmemoSender;
        $this->orderSender = $orderSender;
        $this->quoteRepository = $quoteRepository;
        $this->lockService = $lockService;
        $this->invoiceService =  $invoiceService;
    }

    /**
     * @inheritDoc
     */
    public function createCsrfValidationException(
        RequestInterface $request
    ): ?InvalidRequestException
    {
        return null;
    }

    /**
     * @inheritDoc
     */
    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }

    /**
     * 日志
     * @param $data
     */
    public function saveLog($data)
    {
        file_put_contents(dirname(__FILE__, 3) . "/log/" . "useepay.log", date("Y-m-d H:i:s", time()) . " " . $data . PHP_EOL, FILE_APPEND);
    }

    /**
     * 生成验证签名串
     * @param $arr
     * @param $secretKey
     * @return string
     */
    public function createUnsign($arr, $secretKey)
    {
        if (empty($arr) || empty($secretKey)) {
            return false;
        }
        $str = '';
        ksort($arr);
        foreach ($arr as $key => $value) {
            $v = trim($value);
            if (strlen($v) > 0 && $key != 'sign') {
                $str .= '&' . $key . '=' . $v;
            }
        }
        $str = substr($str, 1);
        $str .= "&pkey=" . trim($secretKey);
        return strtolower(md5($str));
    }

    public function execute()
    {
        // 记录日志
        $result = $_REQUEST;
        $this->saveLog('UseePay back response:');
        $this->saveLog(var_export($result, true));
        $this->saveLog('------------------------------');
        // 载入模块
        $model = $this->_paymentMethod;

        // 获取参数
        $security_code = $model->getConfigData('security_code');

        // 解签
        $res_sign = $this->createUnsign($result, $security_code);

        if ($result['sign'] != $res_sign && '' != $res_sign) {
            $this->messageManager->addError(__('verify sign failed!'));
            $url = 'checkout/cart';
        } else {
            $status_success = $model->getConfigData('success_order_status');
            $status_fail = $model->getConfigData('failure_order_status');
            $transactionId = $result['transactionId'];
            $order = $this->_orderFactory->create()->loadByIncrementId($result['transactionId']);
            $quote = $this->quoteRepository->get($order->getQuoteId())->setIsActive(false);
            $this->quoteRepository->save($quote);
            $status_history = $order->getState();
            $order->getPayment()
                ->setPreparedMessage('')
                ->setTransactionId($result['reference'])
                ->setIsTransactionClosed(0)
                ->update(false);
            if (OrderStatusHelper::isSucceed($result)) {
                if (OrderStatusHelper::canChangeStatus($status_history, $status_success)) {
                    $lock = $this->lockService->lock($transactionId);
                    try {
                        if ($lock) {
                            $order = $this->_orderFactory->create()->loadByIncrementId($transactionId);
                            $status_history = $order->getState();
                            if (OrderStatusHelper::canChangeStatus($status_history, $status_success)) {
                                $order->setState($status_success);
                                $order->setStatus($status_success);
                                $order->setTotalPaid($order->getGrandTotal());
                                $order->setBaseTotalPaid($order->getGrandTotal());
                                $order->addStatusToHistory($status_success, __('payment is successful.'));
                                $order->save();
                                $this->saveLog('UseePay response handle success');
                            }

                            $this->invoiceService->createOrderInvoice($order, $result, $model->getConfigData('invoice'));
                        }
                    } finally {
                        if ($lock) {
                            $this->lockService->unlock($transactionId);
                        }
                    }
                }
                $url = 'checkout/onepage/success';
            } else if (OrderStatusHelper::isFailed($result)) {
                $this->messageManager->addError(__('payment failed! Result Message is: ' . $result["errorMsg"]));
                if (empty($status_history) || ($status_fail != $status_history && $status_history != $status_success)) {
                    $lock = $this->lockService->lock($transactionId);
                    try {
                        if ($lock) {
                            $order = $this->_orderFactory->create()->loadByIncrementId($transactionId);
                            $status_history = $order->getState();
                            if (empty($status_history) || ($status_fail != $status_history && $status_history != $status_success))  {
                                $order->setState($status_fail);
                                $order->setStatus($status_fail);
                                $order->addStatusToHistory($status_fail, __('sorry, payment is failed! Result Message is: ' . $result["errorMsg"]));
                                $order->save();
                            }
                        }
                    } finally {
                        if ($lock) {
                            $this->lockService->unlock($transactionId);
                        }
                    }
                }
                $url = 'checkout/onepage/failure';
                $this->saveLog('UseePay response handle fail');
            } else {
                $this->messageManager->addNoticeMessage(__('payment is processing! Result Message is: ' . $result["errorMsg"]));
                $order->addStatusToHistory($model->getConfigData('new_order_status'), __('payment is processing,  Result Message is: ' . $result["errorMsg"]));
                $url = 'checkout/cart';
                $this->saveLog('UseePay response handle pending');
            }
        }

        $url = $this->urlBuilder->getUrl($url);
        $this->getParentLocationReplace($url);
    }

    /**
     *  JS
     *
     */
    public function getParentLocationReplace($url)
    {
        echo '<script type="text/javascript">parent.location.replace("' . $url . '");</script>';
    }

}


