<?php


namespace UseePay\Applepay\Helper;

use Magento\Sales\Model\Order;

/**
 * 订单状态帮助类
 */
class OrderStatusHelper
{

    public static  function isSucceed($result): bool
    {
        if (empty($result)) {
            return false;
        }
       return 'succeed' == $result['resultCode'];
    }

    public static  function isFailed($result): bool
    {
        if (empty($result)) {
            return false;
        }
        return 'failed' == $result['resultCode'] || 'closed' == $result['resultCode'] || 'cancelled' == $result['resultCode'];
    }

    /**
     * @param $status_history
     * @return bool 需要再加上订单是否完成的状态
     */
    public static  function canChangeStatus($status_history, $status_success): bool
    {
        return empty($status_history) || $status_history != $status_success;
    }
}