<?php

namespace UseePay\Applepay\service;

use Magento\Framework\Lock\LockManagerInterface;

/**
 * 订单状态锁服务类
 */
class LockService
{
    private $lockManager;

    /**
     * @param LockManagerInterface $lockManager 锁管理器
     */
    public function __construct(LockManagerInterface $lockManager) {
        $this->lockManager = $lockManager;
    }

    /**
     * 尝试获取锁
     *
     * @param string $lockName 锁的名称
     * @param int $timeout 超时时间（秒）
     * @return bool 是否成功获取锁
     */
    public function lock($lockName, $timeout = 30)
    {
        $this->saveLog($lockName . ' is being locked');
        try {
            $lockName = 'UseePay_order_lock:' . $lockName;
            if ($this->lockManager->isLocked($lockName)) {
                $this->saveLog($lockName . ' is already locked');
                return false;
            }
            $this->saveLog($lockName . ' is being locked');
            return $this->lockManager->lock($lockName, $timeout);
        } catch (\Exception $e) {
            $this->saveLog('Failed to lock ' . $lockName . ': ' . $e->getMessage());
            return false;
        }
    }

    /**
     * 日志
     * @param $message
     */
    public function saveLog($message)
    {
        file_put_contents(dirname(__FILE__, 2) . "/log/" . "useepay.log", date("Y-m-d H:i:s", time()) . " " . $message . PHP_EOL, FILE_APPEND);
    }

    /**
     * 释放锁
     *
     * @param string $lockName 锁的名称
     * @return bool 是否成功释放锁
     */
    public function unlock($lockName)
    {

        try {
            $lockName = 'UseePay_order_lock:' . $lockName;
            $this->saveLog($lockName . ' is being unlocked');
            return $this->lockManager->unlock($lockName);
        } catch (\Exception $e) {
            $this->saveLog('Failed to unlock ' . $lockName . ': ' . $e->getMessage());
            return false;
        }
    }
}