<?php


namespace UseePay\Payments\Controller\Payment;


use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\Result\JsonFactory;
use UseePay\Payments\Controller\AbsUseePayAction;
use UseePay\Payments\Model\Adminhtml\Source\Config;

class Env extends AbsUseePayAction implements HttpPostActionInterface
{

    /**
     * @var Config
     */
    private $config;
    /**
     * @var JsonFactory
     */
    private $jsonFactory;

    public function __construct(Context $context, Config $config, JsonFactory $jsonFactory)
    {
        parent::__construct($context);
        $this->config      = $config;
        $this->jsonFactory = $jsonFactory;
    }

    public function execute()
    {
        $data     = [];
        $response = $this->jsonFactory->create();
        if (substr($this->config->getEndpoint(), 0, strlen('https://pay-gateway.useepay')) == 'https://pay-gateway.useepay') {
            $env = 'production';
        } else {
            $env = 'sandbox';
        }
        $data['env'] = $env;
        $response->setData($data);
        return $response;
    }
}
