<?php
/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace UseePay\Payments\Model\Ui;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Checkout\Model\Session;
use Magento\Customer\Helper\Session\CurrentCustomer;
use Magento\Framework\Locale\ResolverInterface;
use Magento\Payment\Helper\Data as PaymentHelper;
use Magento\Payment\Model\Method\AbstractMethod;

class ConfigProvider implements ConfigProviderInterface
{
    /**
     * @var ResolverInterface
     */
    protected $localeResolver;

    /**
     * @var Config
     */
    protected $config;

    /**
     * @var CurrentCustomer
     */
    protected $currentCustomer;

    /**
     * @var AbstractMethod[]
     */
    protected $methods = [];

    /**
     * @var PaymentHelper
     */
    protected $paymentHelper;

    protected $checkoutSession;

    /**
     * @param ConfigFactory $configFactory
     * @param ResolverInterface $localeResolver
     * @param CurrentCustomer $currentCustomer
     * @param PaymentHelper $paymentHelper
     */
    public function __construct(
        ResolverInterface $localeResolver,
        CurrentCustomer $currentCustomer,
        Session $checkoutSession,
        PaymentHelper $paymentHelper
    )
    {
        $this->localeResolver  = $localeResolver;
        $this->currentCustomer = $currentCustomer;
        $this->paymentHelper   = $paymentHelper;
        $this->checkoutSession = $checkoutSession;
        $code                  = 'useepay_payments';
        $this->methods[$code]  = $this->paymentHelper->getMethodInstance($code);
    }

    /**
     * {@inheritdoc}
     */
    public function getConfig()
    {
        $code   = 'useepay_payments';
        $config = [];

        if ($this->methods[$code]->isAvailable($this->checkoutSession->getQuote())) {
            $config                                                 = [];
            $config['payment']                                      = [];
            $config['payment']['creditcards']['redirectUrl']        = [];
            $config['payment']['creditcards']['redirectUrl'][$code] = $this->getMethodRedirectUrl($code);
        }

        return $config;
    }

    /**
     * Return redirect URL for method
     *
     * @param string $code
     * @return mixed
     */
    protected function getMethodRedirectUrl($code)
    {
        return $this->methods[$code]->getOrderPlaceRedirectUrl();
    }


}
