<?php


namespace UseePay\Payments\Model\Adminhtml\Source;


use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class Config
{
    const KEY_MERCHANT_NO    = 'payment/useepay_payments/merchant_no';
    const KEY_MD5_SECRET_KEY = 'payment/useepay_payments/secret_key';
    const KEY_ENDPOINT       = 'payment/useepay_payments/endpoint';
    const KEY_APP_ID         = 'payment/useepay_payments/app_id';

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var string
     */
    private $storeScope;

    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
        $this->storeScope  = ScopeInterface::SCOPE_STORE;
    }

    /**
     * @return String
     */
    public function getMerchantNo()
    {
        return $this->scopeConfig->getValue(self::KEY_MERCHANT_NO, $this->storeScope);
    }

    public function getMd5SecretKey()
    {
        return $this->scopeConfig->getValue(self::KEY_MD5_SECRET_KEY, $this->storeScope);
    }

    public function getAppId()
    {
        return $this->scopeConfig->getValue(self::KEY_APP_ID, $this->storeScope);
    }

    public function getEndpoint()
    {
        return $this->scopeConfig->getValue(self::KEY_ENDPOINT, $this->storeScope);
    }

}
