define([
  'jquery',
  'Magento_Checkout/js/model/quote',
  'Magento_Customer/js/customer-data',
  'Magento_Checkout/js/view/payment/default',
  'UseePay_Payments/js/action/set-payment-method',
  'Magento_Checkout/js/model/url-builder',
  'mage/storage',
  'Magento_Checkout/js/model/error-processor',
  'Magento_Customer/js/model/customer',
  'Magento_Checkout/js/model/full-screen-loader',
  'useepayjs',
], function (
  $,
  quote,
  customerData,
  Component,
  setPaymentMethodAction,
  urlBuilder,
  storage,
  errorProcessor,
  customer,
  fullScreenLoader,
) {
  'use strict'

  var useepay;
  var showErrorMsg = function (msg){
    document.getElementById("useepay_error_tip").style.display = "flex"
    document.getElementById("useepay_error_msg").innerHTML = msg
  }

  return Component.extend({
    defaults: {
      template: 'UseePay_Payments/payment/creditcard',
    },
    /** Redirect to creditcard */
    continueToCreditCard: function () {
      this.selectPaymentMethod();
      // setPaymentMethodAction(this.messageContainer);
        setPaymentMethodAction(this.messageContainer).done(
            function () {
                customerData.invalidate(['cart']);
            }
        );
      return false;
    },
    onCheckoutFormRendered: function () {
      storage.post('useepay/payment/env', {}).done(function (data) {
        try {
          useepay = UseePay({
            env: data.env,
            layout: 'multiLine',
            locale: window.navigator.language,
          })
        } catch (e) {
          useepay = UseePay({
            env: 'production',
            layout: 'multiLine',
            locale: window.navigator.language,
          })
        }
        useepay.mount(document.getElementById('cardElement'))
      })
    },
    placeOrder: function () {
      this.selectPaymentMethod();
      customerData.invalidate(['cart']);
      fullScreenLoader.startLoader();
      useepay.validate(function (valid, code, message) {
        if (valid) {
          storage
            .post(
              'useepay/payment/token',
              JSON.stringify({
                quoteId: quote.getQuoteId(),
                email: quote.guestEmail,
              }),
            )
            .done(function (response) {
              if (response.success) {
                useepay.confirm(response['token'], function (data) {
                  if (data.success) {
                    storage
                      .post('useepay/payment/syncResult', data.data)
                      .done(function (result) {
                        if (result.success) {
                          // showErrorMsg(result.message) // 跳转到成功页，当前页面无需提示成功，所以注释掉这句
                          if (
                            result.redirectUrl !== '' &&
                            result.redirectUrl != null &&
                            result.redirectUrl != undefined
                          ) {
                              window.location.href = result.redirectUrl;
                          }
                        } else {
                          fullScreenLoader.stopLoader()
                          showErrorMsg(result.message)
                        }
                      })
                  } else {
                    fullScreenLoader.stopLoader()
                    showErrorMsg(data.message)
                  }
                })
              } else {
                fullScreenLoader.stopLoader()
                showErrorMsg(response.message)
              }
            })
            .fail(function (response) {
              fullScreenLoader.stopLoader()
              showErrorMsg(response)
            })
        } else {
          fullScreenLoader.stopLoader()
          showErrorMsg(message)
        }
      })
    },
  })
})
