<?php

namespace UseePay\Wechat\Controller\Payment;


use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Sales\Model\Order\Email\Sender\InvoiceSender;

class Back extends \Magento\Framework\App\Action\Action implements CsrfAwareActionInterface
{

    const BrowserReturn = "[Browser Return]";

    protected $_processingArray = array('processing', 'complete');


    /**
     * Customer session model
     *
     * @var \Magento\Customer\Model\Session
     */
    protected $_customerSession;
    protected $resultPageFactory;
    protected $checkoutSession;
    protected $orderRepository;
    protected $_scopeConfig;
    protected $_orderFactory;
    protected $creditmemoSender;
    protected $orderSender;
    protected $urlBuilder;
    protected $invoiceSender;
    /**
     * @var \Magento\Quote\Api\CartRepositoryInterface
     */
    protected $quoteRepository;

    /**
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Customer\Model\Session $customerSession
     */
    public function __construct(
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\App\Action\Context $context,
        \UseePay\Wechat\Model\PaymentMethod $paymentMethod,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Magento\Sales\Model\OrderFactory $orderFactory,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Sales\Model\Order\Email\Sender\CreditmemoSender $creditmemoSender,
        \Magento\Sales\Model\Order\Email\Sender\OrderSender $orderSender,
        \Magento\Framework\Url $urlBuilder,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        InvoiceSender $invoiceSender,
        \Magento\Quote\Api\CartRepositoryInterface $quoteRepository
    )
    {
        $this->_customerSession = $customerSession;
        $this->checkoutSession = $checkoutSession;
        $this->urlBuilder = $urlBuilder;
        $this->orderRepository = $orderRepository;
        parent::__construct($context);
        $this->_scopeConfig = $scopeConfig;
        $this->_orderFactory = $orderFactory;
        $this->_paymentMethod = $paymentMethod;
        $this->creditmemoSender = $creditmemoSender;
        $this->orderSender = $orderSender;
        $this->invoiceSender = $invoiceSender;
        $this->quoteRepository = $quoteRepository;
    }

    /**
     * @inheritDoc
     */
    public function createCsrfValidationException(
        RequestInterface $request
    ): ?InvalidRequestException {
        return null;
    }

    /**
     * @inheritDoc
     */
    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }


    protected function _createInvoice($order)
    {
        if (!$order->canInvoice()) {
            return;
        }

        $invoice = $order->prepareInvoice();
        if (!$invoice->getTotalQty()) {
            throw new \RuntimeException("Cannot create an invoice without products.");
        }

        $invoice->setRequestedCaptureCase(\Magento\Sales\Model\Order\Invoice::CAPTURE_OFFLINE);
        $invoice->register();
        $order->addRelatedObject($invoice);
//        if ($invoice) {
//            $this->invoiceSender->send($invoice);
//        }
        $invoiceCollection = $order->getInvoiceCollection();
        foreach ($invoiceCollection as $_invoice) {
            if (!$_invoice->getEmailSent()) {
                $this->invoiceSender->send($_invoice);
            }
        }
    }

    /**
     * 日志
     * @param $data
     */
    public function saveLog($data)
    {
        file_put_contents(dirname(dirname(dirname(__FILE__))) . "/log/" . "UseePay.log", date("Y-m-d H:i:s", time()) . " " . $data . PHP_EOL, FILE_APPEND);
    }

    /**
     * 生成验证签名串
     * @param $arr
     * @param $secretKey
     * @return string
     */
    public function createUnsign($arr, $secretKey)
    {
        if (empty($arr) || empty($secretKey)) {
            return false;
        }
        $str = '';
        ksort($arr);
        foreach ($arr as $key => $value) {
            $v = trim($value);
            if (strlen($v) > 0 && $key != 'sign') {
                $str .= '&' . $key . '=' . $v;
            }
        }
        $str = substr($str, 1);
        $str .= "&pkey=" . trim($secretKey);
        return strtolower(md5($str));
    }

    public function execute()
    {
        // 记录日志
        $result = $_REQUEST;
//        $result   = json_decode($this->getRequest()->getContent(), true);
        $this->saveLog('UseePay response:');
        $this->saveLog(var_export($result, true));
        $this->saveLog('------------------------------');
        // 载入模块
        $model = $this->_paymentMethod;

        // 获取参数
        $security_code = $model->getConfigData('security_code');

        // 解签
        $res_sign = $this->createUnsign($result, $security_code);


        if ($result['sign'] != $res_sign && '' != $res_sign) {
            $this->messageManager->addError(__('verify sign failed!'));
            $url = 'checkout/cart';
        } else {
            $status_success = $model->getConfigData('success_order_status');
            $status_fail = $model->getConfigData('failure_order_status');
            $order = $this->_orderFactory->create()->loadByIncrementId($result['transactionId']);
            $quote = $this->quoteRepository->get($order->getQuoteId())->setIsActive(false);
            $this->quoteRepository->save($quote);
//            $this->quoteRepository->delete($quote);
//            $this->checkoutSession->clearQuote()->clearStorage();

            $status_history = $order->getState();
            $order->getPayment()
                ->setPreparedMessage('')
                ->setTransactionId($result['reference'])
                ->setIsTransactionClosed(0)
                ->update(false);
            if ('succeed' == $result['resultCode']) {
                if (empty($status_history) || $status_history != $status_success) {
                    $order->setState($status_success);
                    $order->setStatus($status_success);
                    $order->setTotalPaid($order->getGrandTotal());
                    $order->setBaseTotalPaid($order->getGrandTotal());
                    $order->addStatusToHistory($status_success, __('payment is successful.'));
//                    if ($model->getConfigData('invoice')) {
//                        $this->_createInvoice($order);
//                    }
                    $order->save();
                    $this->saveLog('UseePay response handle success');
//                    if (!$order->getEmailSent()) {
//                        $this->orderSender->send($order);
//                        $order->addStatusHistoryComment('payment is successful.')
//                            ->setIsCustomerNotified(true)
//                            ->save();
//                    }
                }
                $url = 'checkout/onepage/success';
            } else if ('failed' == $result['resultCode'] || 'closed' == $result['resultCode'] || 'canceled' == $result['resultCode']) {
                $this->messageManager->addError(__('payment failed! Result Message is: ' . $result["errorMsg"]));
                if (empty($status_history) || ($status_fail != $status_history && $status_history != $status_success)) {
                    $order->setState($status_fail);
                    $order->setStatus($status_fail);
                    $order->addStatusToHistory($status_fail, __('sorry, payment is failed! Result Message is: ' . $result["errorMsg"]));
                    $order->save();
                }
                $url = 'checkout/onepage/failure';
                $this->saveLog('UseePay response handle fail');
            } else {
                $this->messageManager->addNoticeMessage(__('payment is processing! Result Message is: ' . $result["errorMsg"]));
                $order->addStatusToHistory($model->getConfigData('new_order_status'), __('payment is processing,  Result Message is: ' . $result["errorMsg"]));
                $url = 'checkout/cart';
                $this->saveLog('UseePay response handle pending');
            }
        }

        $url = $this->urlBuilder->getUrl($url);
        $this->getParentLocationReplace($url);
    }

    /**
     *  JS
     *
     */
    public function getParentLocationReplace($url)
    {
        echo '<script type="text/javascript">parent.location.replace("' . $url . '");</script>';
    }

}


