<?php

namespace UseePay\Wechat\Controller\Payment;

use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Quote\Api\CartManagementInterface;
use Magento\Sales\Model\Order\Email\Sender\InvoiceSender;

class Notice extends \Magento\Framework\App\Action\Action implements CsrfAwareActionInterface
{
    const PUSH = "[PUSH]";
    protected $_processingArray = array(
        'processing',
        'complete'
    );

    /**
     * Customer session model
     *
     * @var \Magento\Customer\Model\Session
     */
    protected $_customerSession;
    protected $resultPageFactory;
    protected $checkoutSession;
    protected $orderRepository;
    protected $_scopeConfig;
    protected $_orderFactory;
    protected $creditmemoSender;
    protected $orderSender;
    protected $invoiceSender;
    /**
     * @var \Magento\Quote\Api\CartRepositoryInterface
     */
    protected $quoteRepository;

    /**
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Customer\Model\Session $customerSession
     */
    public function __construct(\Magento\Customer\Model\Session $customerSession, \Magento\Framework\App\Action\Context $context, \UseePay\Wechat\Model\PaymentMethod $paymentMethod, \Magento\Sales\Api\OrderRepositoryInterface $orderRepository, \Magento\Sales\Model\OrderFactory $orderFactory, \Magento\Checkout\Model\Session $checkoutSession, \Magento\Sales\Model\Order\Email\Sender\CreditmemoSender $creditmemoSender, \Magento\Sales\Model\Order\Email\Sender\OrderSender $orderSender, \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig, InvoiceSender $invoiceSender, \Magento\Quote\Api\CartRepositoryInterface $quoteRepository)
    {
        $this->_customerSession = $customerSession;
        $this->checkoutSession = $checkoutSession;
        $this->orderRepository = $orderRepository;
        parent::__construct($context);
        $this->_scopeConfig = $scopeConfig;
        $this->_orderFactory = $orderFactory;
        $this->_paymentMethod = $paymentMethod;
        $this->creditmemoSender = $creditmemoSender;
        $this->orderSender = $orderSender;
        $this->invoiceSender = $invoiceSender;
        $this->quoteRepository = $quoteRepository;
    }

    /**
     * @inheritDoc
     */
    public function createCsrfValidationException(
        RequestInterface $request
    ): ?InvalidRequestException {
        return null;
    }

    /**
     * @inheritDoc
     */
    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }

    protected function _createInvoice($order)
    {
        if (!$order->canInvoice()) {
            return;
        }

        $invoice = $order->prepareInvoice();
        if (!$invoice->getTotalQty()) {
            throw new \RuntimeException ("Cannot create an invoice without products.");
        }

        $invoice->setRequestedCaptureCase(\Magento\Sales\Model\Order\Invoice::CAPTURE_OFFLINE);
        $invoice->register();
        $order->addRelatedObject($invoice);
//        if ($invoice) {
//            $this->invoiceSender->send($invoice);
//        }
    }

    /**
     * 日志
     * @param $data
     */
    public function saveLog($data)
    {
        file_put_contents(dirname(dirname(dirname(__FILE__))) . "/log/" . "UseePay.log", date("Y-m-d H:i:s", time()) . " " . $data . PHP_EOL, FILE_APPEND);
    }

    /**
     * 生成验证签名串
     * @param $arr
     * @param $secretKey
     * @return string
     */
    public function createUnsign($arr, $secretKey)
    {
        if (empty($arr) || empty($secretKey)) {
            return false;
        }
        $str = '';
        ksort($arr);
        foreach ($arr as $key => $value) {
            $v = trim($value);
            if (strlen($v) > 0 && $key != 'sign') {
                $str .= '&' . $key . '=' . $v;
            }
        }
        $str = substr($str, 1);
        $str .= "&pkey=" . trim($secretKey);
        return strtolower(md5($str));
    }

    public function execute()
    {
//        sleep(15);

        // 记录日志
        $result = $_POST;
        $this->saveLog('UseePay response-notify:');
        $this->saveLog(var_export($result, true));
        $this->saveLog('------------------------------');

        // 载入模块
        $model = $this->_paymentMethod;

        // 获取相关状态
        $status_success = $model->getConfigData('success_order_status');    // 配置的成功状态
        $status_failure = $model->getConfigData('failure_order_status');    // 配置的失败状态

        if (isset($result['resultCode'])) {
            // 获取参数
            $sign_key = $model->getConfigData('security_code');

            // 解签
            $res_sign = $this->createUnsign($_POST, $sign_key);

            if ($result['sign'] != $res_sign) {
                $this->saveLog('UseePay response-notify: verify sign failed!');
                echo 'OK';
                return;
            }

            // API2.0
            // 获取订单目前状态
            $order = $this->_orderFactory->create()->loadByIncrementId($result['transactionId']);
            $quote = $this->quoteRepository->get($order->getQuoteId())->setIsActive(false);
            $this->quoteRepository->save($quote);
            $status_history = $order->getState();
            $order->getPayment()
                ->setPreparedMessage('')
                ->setTransactionId($result['reference'])
                ->setIsTransactionClosed(0)
                ->update(false);
            if ('succeed' == $result['resultCode']) {
                $order->setState($status_success);
                $order->setStatus($status_success);
                $order->addStatusToHistory($status_success, __('payment is successful. Result Message is: ' . $result['errorMsg']));
                if ($model->getConfigData('invoice')) {
                    $this->_createInvoice($order);
                }
                $order->setTotalPaid($order->getGrandTotal());
                $order->setBaseTotalPaid($order->getGrandTotal());
                $order->save();
                if (!$order->getEmailSent()) {
                    $this->orderSender->send($order);
                    $order->addStatusHistoryComment('payment is successful.')
                        ->setIsCustomerNotified(true)
                        ->save();
                }
                $invoiceCollection = $order->getInvoiceCollection();
                foreach ($invoiceCollection as $_invoice) {
                    if (!$_invoice->getEmailSent()) {
                        $this->invoiceSender->send($_invoice);
                    }
                }
            } else if ('failed' == $result['resultCode'] || 'closed' == $result['resultCode'] || 'canceled' == $result['resultCode']) {
                if (empty($status_history) || ($status_history != $status_failure && $status_history != $status_success)) {
                    $order->setState($status_failure);
                    $order->setStatus($status_failure);
                    $order->addStatusToHistory($status_failure, __('sorry, payment is failed. Result Message is: ' . $result["errorMsg"]));
                    $order->save();
                }
            } else {
                $order->addStatusToHistory($model->getConfigData('new_order_status'), __('payment is processing, Result Message is: ' . $result["errorMsg"]));
            }
        }
        echo 'OK';
    }
}


