<?php

class ControllerPaymentUseepay extends Controller
{
    private $error = array();

    public function index()
    {
        // 加载配置
        $this->load->language('payment/useepay');
        $this->load->model('setting/setting');

        $this->document->setTitle($this->language->get('heading_title'));

        // 保存表单数据
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
            $this->model_setting_setting->editSetting('useepay', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
        }

        // 常量
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_edit'] = $this->language->get('text_edit');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');
        $data['text_all_zones'] = $this->language->get('text_all_zones');
        $data['text_yes'] = $this->language->get('text_yes');
        $data['text_no'] = $this->language->get('text_no');
        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');
        $data['tab_general'] = $this->language->get('tab_general');

        $data['entry_payment_title'] = $this->language->get('entry_payment_title');
        $data['entry_merchant_no'] = $this->language->get('entry_merchant_no');
        $data['entry_transaction_type'] = $this->language->get('entry_transaction_type');
        $data['entry_payment_method'] = $this->language->get('entry_payment_method');

        $data['entry_app_id'] = $this->language->get('entry_app_id');
        $data['entry_transaction_expiration_time'] = $this->language->get('entry_transaction_expiration_time');
        $data['entry_supported_card_type'] = $this->language->get('entry_supported_card_type');
        $data['entry_sign_type'] = $this->language->get('entry_sign_type');
        $data['entry_sign_key'] = $this->language->get('entry_sign_key');
        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_success_order_status'] = $this->language->get('entry_success_order_status');
        $data['entry_failed_order_status'] = $this->language->get('entry_failed_order_status');
        $data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
        $data['entry_status'] = $this->language->get('entry_status');
        $data['entry_authorization_method'] = $this->language->get('entry_authorization_method');
        $data['entry_sort_order'] = $this->language->get('entry_sort_order');
        $data['entry_payment_env'] = $this->language->get('entry_payment_env');

        // 错误提交提示
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }
        if (isset($this->error['payment_title'])) {
            $data['error_payment_title'] = $this->error['payment_title'];
        } else {
            $data['error_payment_title'] = '';
        }
        if (isset($this->error['merchant'])) {
            $data['error_merchant_no'] = $this->error['merchant'];
        } else {
            $data['error_merchant_no'] = '';
        }
        if (isset($this->error['sign_key'])) {
            $data['error_sign_key'] = $this->error['sign_key'];
        } else {
            $data['error_sign_key'] = '';
        }
        if (isset($this->error['app_id'])) {
            $data['error_app_id'] = $this->error['app_id'];
        } else {
            $data['error_app_id'] = '';
        }
        if (isset($this->error['transaction_expiration_time'])) {
            $data['error_transaction_expiration_time'] = $this->error['transaction_expiration_time'];
        } else {
            $data['error_transaction_expiration_time'] = '';
        }
        if (isset($this->error['card_type'])) {
            $data['error_supported_card_type'] = $this->error['card_type'];
        } else {
            $data['error_supported_card_type'] = '';
        }

        // 导航栏常量
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL'),
            'text' => $this->language->get('text_home'),
        );
        $data['breadcrumbs'][] = array(
            'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'),
            'text' => $this->language->get('text_extension'),
        );
        $data['breadcrumbs'][] = array(
            'href' => $this->url->link('payment/useepay', 'token=' . $this->session->data['token'], 'SSL'),
            'text' => $this->language->get('heading_title'),
        );

        // 提交按钮与取消按钮对应的URL
        $data['action'] = $this->url->link('payment/useepay', 'token=' . $this->session->data['token'], 'SSL');
        $data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');

        // 渲染表单数据(1.错误提交保存上次提交数据 2.初次打开页面显示默认值)
        if (isset($this->request->post['useepay_payment_title'])) {
            $data['useepay_payment_title'] = $this->request->post['useepay_payment_title'];
        } else {
            $data['useepay_payment_title'] = $this->config->get('useepay_payment_title');
        }
        if (isset($this->request->post['useepay_merchant_no'])) {
            $data['useepay_merchant_no'] = $this->request->post['useepay_merchant_no'];
        } else {
            $data['useepay_merchant_no'] = $this->config->get('useepay_merchant_no');
        }
        if (isset($this->request->post['useepay_sign_type'])) {
            $data['useepay_sign_type'] = $this->request->post['useepay_sign_type'];
        } else {
            $data['useepay_sign_type'] = $this->config->get('useepay_sign_type');
        }
        if (isset($this->request->post['useepay_sign_key'])) {
            $data['useepay_sign_key'] = $this->request->post['useepay_sign_key'];
        } else {
            $data['useepay_sign_key'] = $this->config->get('useepay_sign_key');
        }
        if (isset($this->request->post['useepay_authorization_method'])) {
            $data['useepay_authorization_method'] = $this->request->post['useepay_authorization_method'];
        } else {
            $data['useepay_authorization_method'] = $this->config->get('useepay_authorization_method');
        }
        if (isset($this->request->post['useepay_app_id'])) {
            $data['useepay_app_id'] = $this->request->post['useepay_app_id'];
        } else {
            $data['useepay_app_id'] = $this->config->get('useepay_app_id');
        }
        if (isset($this->request->post['useepay_transaction_expiration_time'])) {
            $data['useepay_transaction_expiration_time'] = $this->request->post['useepay_transaction_expiration_time'];
        } else {
            $data['useepay_transaction_expiration_time'] = $this->config->get('useepay_transaction_expiration_time');
        }
        if (isset($this->request->post['useepay_supported_card_type'])) {
            $data['useepay_supported_card_type'] = $this->request->post['useepay_supported_card_type'];
        } else {
            $data['useepay_supported_card_type'] = $this->config->get('useepay_supported_card_type');
        }
        if (isset($this->request->post['useepay_order_status_id'])) {
            $data['useepay_order_status_id'] = $this->request->post['useepay_order_status_id'];
        } else {
            $data['useepay_order_status_id'] = $this->config->get('useepay_order_status_id');
        }
        if (isset($this->request->post['useepay_succeed_order_status_id'])) {
            $data['useepay_succeed_order_status_id'] = $this->request->post['useepay_succeed_order_status_id'];
        } else {
            $data['useepay_succeed_order_status_id'] = $this->config->get('useepay_succeed_order_status_id');
        }
        if (isset($this->request->post['useepay_failed_order_status_id'])) {
            $data['useepay_failed_order_status_id'] = $this->request->post['useepay_failed_order_status_id'];
        } else {
            $data['useepay_failed_order_status_id'] = $this->config->get('useepay_failed_order_status_id');
        }
        if (isset($this->request->post['useepay_geo_zone_id'])) {
            $data['useepay_geo_zone_id'] = $this->request->post['useepay_geo_zone_id'];
        } else {
            $data['useepay_geo_zone_id'] = $this->config->get('useepay_geo_zone_id');
        }
        if (isset($this->request->post['useepay_status'])) {
            $data['useepay_status'] = $this->request->post['useepay_status'];
        } else {
            $data['useepay_status'] = $this->config->get('useepay_status');
        }
        if (isset($this->request->post['useepay_sort_order'])) {
            $data['useepay_sort_order'] = $this->request->post['useepay_sort_order'];
        } else {
            $data['useepay_sort_order'] = $this->config->get('useepay_sort_order');
        }
        if (isset($this->request->post['useepay_transaction_type'])) {
            $data['useepay_transaction_type'] = $this->request->post['useepay_transaction_type'];
        } else {
            $data['useepay_transaction_type'] = $this->config->get('useepay_transaction_type');
        }
        if (isset($this->request->post['useepay_payment_method'])) {
            $data['useepay_payment_method'] = $this->request->post['useepay_payment_method'];
        } else {
            $data['useepay_payment_method'] = $this->config->get('useepay_payment_method');
        }
        if (isset($this->request->post['useepay_env'])) {
            $data['useepay_env'] = $this->request->post['useepay_env'];
        } else {
            $data['useepay_env'] = $this->config->get('useepay_env');
        }

        // 参数变量数组
        $data['sign_types'] = $this->language->get('text_sign_type');
        $data['authorization_methods'] = $this->language->get('text_authorization_method');
        $data['transaction_types'] = $this->language->get('text_transaction_type');
        $data['payment_methods'] = $this->language->get('text_payment_method');   // 支付方式
        $data['card_types'] = $this->language->get('text_card_type');   // 卡组织类型
        $data['environments'] = $this->language->get('text_environment'); // 环境
        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();   // 支付状态
        $this->load->model('localisation/geo_zone');
        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();// 地区

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        // 渲染模板页面
        $this->response->setOutput($this->load->view('payment/useepay', $data));
    }

    /**
     * 表单验证
     * @return bool
     */
    private function validate()
    {
        if (!$this->user->hasPermission('modify', 'payment/useepay')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['useepay_payment_title']) {
            $this->error['payment_title'] = $this->language->get('error_payment_title');
        }

        if (!$this->request->post['useepay_merchant_no']) {
            $this->error['merchant'] = $this->language->get('error_merchant_no');
        }

        if (!$this->request->post['useepay_sign_key']) {
            $this->error['sign_key'] = $this->language->get('error_sign_key');
        }

        if (!$this->request->post['useepay_app_id']) {
            $this->error['app_id'] = $this->language->get('error_app_id');
        }

        if (!$this->request->post['useepay_transaction_expiration_time']) {
            $this->error['transaction_expiration_time'] = $this->language->get('error_transaction_expiration_time');
        }

        if (!isset($this->request->post['useepay_supported_card_type'])) {
            $this->error['card_type'] = $this->language->get('error_supported_card_type');
            $this->request->post['useepay_supported_card_type'] = [];
        }

        return !$this->error;
    }

    public function install()
    {
        $this->load->model('payment/useepay');
        $this->model_payment_useepay->install();
    }

    public function uninstall()
    {
        $this->load->model('payment/useepay');
        $this->model_payment_useepay->uninstall();
    }

}
